/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.impl;

import edu.wlu.cs.levy.CG.KDTree;
import java.awt.Color;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.RectangularVolumeRegion;
import org.eclipse.apogy.core.environment.surface.impl.CartesianTriangularMeshSlopeImageMapLayerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CartesianTriangularMeshSlopeImageMapLayerCustomImpl
extends CartesianTriangularMeshSlopeImageMapLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(CartesianTriangularMeshSlopeImageMapLayerImpl.class);

    @Override
    public void updateImage(IProgressMonitor progressMonitor) {
        CartesianTriangularMesh mesh;
        if (this.getCartesianTriangularMeshMapLayer() != null && (mesh = this.getCartesianTriangularMeshMapLayer().getCurrentMesh()) != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)4);
            long startTime = System.currentTimeMillis();
            RectangularVolumeRegion meshRegion = this.getRectangularVolumeRegion();
            if (meshRegion.getXDimension() > 0.0 && meshRegion.getYDimension() > 0.0) {
                if (progressMonitor.isCanceled()) {
                    return;
                }
                Point3d[][] pixelsLocation = this.getPixelsLocation(this.getCartesianTriangularMeshMapLayer().getCurrentMesh(), (IProgressMonitor)subMonitor.newChild(1));
                int numberPixelAlongX = pixelsLocation.length;
                int numberPixelAlongY = pixelsLocation[0].length;
                double xIncrement = meshRegion.getXDimension() / (double)numberPixelAlongX;
                double yIncrement = meshRegion.getYDimension() / (double)numberPixelAlongY;
                double averagingRadius = Math.sqrt(xIncrement * xIncrement + yIncrement * yIncrement);
                if (progressMonitor.isCanceled()) {
                    return;
                }
                KDTree kdTree = this.createTriangleKDTree(mesh, (IProgressMonitor)subMonitor.newChild(1));
                if (progressMonitor.isCanceled()) {
                    return;
                }
                CartesianTriangle[][] pixelsIntersectionTriangles = this.getPixelsIntersectionTriangle(pixelsLocation, mesh, kdTree, averagingRadius, progressMonitor);
                if (progressMonitor.isCanceled()) {
                    return;
                }
                Vector3d[][] normalsArray = this.getNormals(pixelsLocation, pixelsIntersectionTriangles, mesh, kdTree, averagingRadius, progressMonitor);
                SlopeExtremes slopeExtremes = this.getSlopeExtremes(pixelsIntersectionTriangles);
                double meshMinimumSlope = slopeExtremes.minimumSlope;
                double meshMaximumSlope = slopeExtremes.maximumSlope;
                if (progressMonitor.isCanceled()) {
                    return;
                }
                int[][] pixelColors = this.getPixelsColor(normalsArray, meshMinimumSlope, meshMaximumSlope);
                if (progressMonitor.isCanceled()) {
                    return;
                }
                AbstractEImage image = this.convertToImage(pixelColors, (IProgressMonitor)subMonitor.newChild(1));
                long endTime = System.currentTimeMillis();
                double duration = (double)(endTime - startTime) * 0.001;
                Logger.info("Updated image in <" + duration + "> seconds.");
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.IMAGE_MAP_LAYER__IMAGE, (Object)image);
            }
        }
    }

    protected int[][] getPixelsColor(Vector3d[][] normalsArray, double meshMinimumSlope, double meshMaximumSlope) {
        int numberPixelAlongX = normalsArray.length;
        int numberPixelAlongY = normalsArray[0].length;
        int[][] pixelColors = new int[numberPixelAlongX][numberPixelAlongY];
        int i = 0;
        while (i < numberPixelAlongX) {
            int j = 0;
            while (j < numberPixelAlongY) {
                Vector3d normal = normalsArray[i][j];
                if (normal != null) {
                    double slope = Math.acos(Math.abs(normal.z));
                    pixelColors[i][j] = this.getColor(meshMinimumSlope, meshMaximumSlope, slope);
                }
                ++j;
            }
            ++i;
        }
        return pixelColors;
    }

    protected SlopeExtremes getSlopeExtremes(CartesianTriangle[][] triangles) {
        double minSlope = Double.POSITIVE_INFINITY;
        double maxSlope = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < triangles.length) {
            int j = 0;
            while (j < triangles[0].length) {
                CartesianTriangle triangle = triangles[i][j];
                if (triangle != null) {
                    Vector3d normal = triangle.getNormal();
                    normal.normalize();
                    double slope = Math.acos(Math.abs(normal.z));
                    if (slope < minSlope) {
                        minSlope = slope;
                    }
                    if (slope > maxSlope) {
                        maxSlope = slope;
                    }
                }
                ++j;
            }
            ++i;
        }
        SlopeExtremes result = new SlopeExtremes();
        result.minimumSlope = minSlope;
        result.maximumSlope = maxSlope;
        return result;
    }

    protected int getColor(double meshMinimumSlope, double meshMaximumSlope, double slope) {
        double factor = 0.0;
        factor = this.isAutoScale() ? (slope - meshMinimumSlope) / (meshMaximumSlope - meshMinimumSlope) : (slope - Math.toRadians(this.getMinimumSlope())) / (Math.toRadians(this.getMaximumSlope()) - Math.toRadians(this.getMinimumSlope()));
        if (factor < 0.0) {
            factor = 0.0;
        }
        if (factor > 1.0) {
            factor = 1.0;
        }
        float hue = (float)(0.666 - factor * 0.666);
        Color color = Color.getHSBColor(hue, 0.9f, 0.9f);
        return color.getRGB();
    }

    protected class SlopeExtremes {
        public double maximumSlope = 0.0;
        public double minimumSlope = 0.0;

        protected SlopeExtremes() {
        }
    }
}

