/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.ui.impl;

import org.eclipse.apogy.core.environment.ui.Activator;
import org.eclipse.apogy.core.environment.ui.impl.StarFieldPresentationImpl;
import org.eclipse.apogy.core.environment.ui.scene_objects.StarFieldSceneObject;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class StarFieldPresentationCustomImpl
extends StarFieldPresentationImpl {
    private IPropertyChangeListener iPropertyChangeListener;

    protected StarFieldPresentationCustomImpl() {
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getIPropertyChangeListener());
    }

    @Override
    public void setCutOffMagnitude(float newCutOffMagnitude) {
        super.setCutOffMagnitude(newCutOffMagnitude);
        StarFieldSceneObject j3DObject = (StarFieldSceneObject)this.sceneObject;
        j3DObject.setCutOffMagnitude(newCutOffMagnitude);
    }

    public boolean isUseInBoundingCalculation() {
        return false;
    }

    protected void initialSceneObject() {
        this.applyPreferences();
        super.initialSceneObject();
    }

    protected void applyPreferences() {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        StarFieldSceneObject starFieldSceneObject = (StarFieldSceneObject)this.sceneObject;
        starFieldSceneObject.setCutOffMagnitude(preferenceStore.getFloat("DEFAULT_STAR_MAGNITUDE_CUTOFF_ID"));
        super.applyPreferences();
    }

    protected void updateSceneObject(Notification notification) {
        if (this.sceneObject != null) {
            StarFieldSceneObject starFieldSceneObject = (StarFieldSceneObject)this.sceneObject;
            int featureID = notification.getFeatureID(StarFieldPresentationCustomImpl.class);
            switch (featureID) {
                case 16: {
                    starFieldSceneObject.setTransparency(notification.getNewFloatValue());
                    break;
                }
                case 17: {
                    starFieldSceneObject.setCutOffMagnitude(notification.getNewFloatValue());
                    break;
                }
            }
        }
        super.updateSceneObject(notification);
    }

    protected IPropertyChangeListener getIPropertyChangeListener() {
        if (this.iPropertyChangeListener == null) {
            this.iPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    StarFieldPresentationCustomImpl.this.applyPreferences();
                }
            };
        }
        return this.iPropertyChangeListener;
    }
}

