/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.composites;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.EObjectReference;
import org.eclipse.apogy.common.emf.FeaturePathAdapter;
import org.eclipse.apogy.common.emf.impl.FeaturePathAdapterCustomImpl;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.Activator;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EOperationEParametersFormatProviderParameters;
import org.eclipse.apogy.common.emf.ui.EOperationEParametersUnitsProviderParameters;
import org.eclipse.apogy.common.emf.ui.preferences.PreferencesConstants;
import org.eclipse.apogy.common.emf.ui.wizards.ChooseEClassWizard;
import org.eclipse.apogy.common.emf.ui.wizards.NewChildWizard;
import org.eclipse.apogy.common.ui.ApogyCommonUiFacade;
import org.eclipse.apogy.common.ui.composites.NoContentComposite;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.Argument;
import org.eclipse.apogy.core.invocator.BooleanEDataTypeArgument;
import org.eclipse.apogy.core.invocator.EClassArgument;
import org.eclipse.apogy.core.invocator.EDataTypeArgument;
import org.eclipse.apogy.core.invocator.EEnumArgument;
import org.eclipse.apogy.core.invocator.NumericEDataTypeArgument;
import org.eclipse.apogy.core.invocator.OperationCall;
import org.eclipse.apogy.core.invocator.StringEDataTypeArgument;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArgumentsComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(ArgumentsComposite.class);
    private TreeViewer treeViewer;
    private Button btnNew;
    private Button btnDelete;
    private Composite compositeEMFForms;
    boolean emfForms;
    private OperationCall operationCall;
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private FeaturePathAdapter adapter;
    private IPropertyChangeListener propertyChangeListener;
    private DataBindingContext m_bindingContext;

    public ArgumentsComposite(Composite parent, int style) {
        super(parent, style);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPropertyChangeListener());
        this.setLayout((Layout)new FillLayout());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ArgumentsComposite.this.operationCall != null) {
                    ArgumentsComposite.this.getAdapter().dispose();
                }
                ArgumentsComposite.this.adapterFactory.dispose();
                if (ArgumentsComposite.this.m_bindingContext != null) {
                    ArgumentsComposite.this.m_bindingContext.dispose();
                }
                if (ArgumentsComposite.this.propertyChangeListener != null) {
                    Activator.getDefault().getPreferenceStore().removePropertyChangeListener(ArgumentsComposite.this.getPropertyChangeListener());
                }
            }
        });
        this.emfForms = false;
        Composite compositeArguments = new Composite((Composite)this, 0);
        compositeArguments.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer(compositeArguments, 68356);
        Tree treeInstance = this.treeViewer.getTree();
        treeInstance.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        treeInstance.setLinesVisible(true);
        treeInstance.setHeaderVisible(true);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ArgumentsComposite.this.treeViewer.getStructuredSelection() != null) {
                    Object obj = ArgumentsComposite.this.treeViewer.getStructuredSelection().getFirstElement();
                    if (ArgumentsComposite.this.emfForms && ((StructuredSelection)event.getSelection()).getFirstElement() != null && (!ArgumentsComposite.this.getArguments().contains(((StructuredSelection)event.getSelection()).getFirstElement()) || obj instanceof Argument && ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)((Argument)obj).getEParameter()) != null)) {
                        if (ArgumentsComposite.this.compositeEMFForms instanceof NoContentComposite) {
                            ArgumentsComposite.this.compositeEMFForms.dispose();
                            ArgumentsComposite.this.compositeEMFForms = new Composite((Composite)ArgumentsComposite.this, 0);
                            ArgumentsComposite.this.compositeEMFForms.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(10, 10).create());
                            ArgumentsComposite.this.layout();
                        } else {
                            Control[] controlArray = ArgumentsComposite.this.compositeEMFForms.getChildren();
                            int n = controlArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Control control = controlArray[n2];
                                control.dispose();
                                ++n2;
                            }
                        }
                        try {
                            ECPSWTViewRenderer.INSTANCE.render(ArgumentsComposite.this.compositeEMFForms, (EObject)((StructuredSelection)event.getSelection()).getFirstElement());
                        }
                        catch (ECPRendererException e) {
                            Logger.warn(".selectionChanged(): Error while opening EMF Forms");
                        }
                        ArgumentsComposite.this.compositeEMFForms.layout();
                    } else if (ArgumentsComposite.this.emfForms && !(ArgumentsComposite.this.compositeEMFForms instanceof NoContentComposite)) {
                        ArgumentsComposite.this.compositeEMFForms.dispose();
                        ArgumentsComposite.this.compositeEMFForms = (Composite)ArgumentsComposite.this.getNoSelectionComposite(ArgumentsComposite.this, 0);
                        ArgumentsComposite.this.layout();
                    }
                }
                ArgumentsComposite.this.newSelection(event.getSelection());
            }
        });
        TreeViewerColumn treeViewerActionColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn treeclmnAction = treeViewerActionColumn.getColumn();
        treeclmnAction.setWidth(100);
        treeclmnAction.setText("Parameter");
        TreeViewerColumn treeViewerParameterColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn treeclmnParameter = treeViewerParameterColumn.getColumn();
        treeclmnParameter.setWidth(100);
        treeclmnParameter.setText("Value");
        ApogyCommonUiFacade.INSTANCE.addExpandOnDoubleClick(this.treeViewer);
        treeViewerParameterColumn.setEditingSupport((EditingSupport)new ArgumentsEditor((ColumnViewer)this.treeViewer));
        this.btnNew = new Button(compositeArguments, 0);
        this.btnNew.setText("New");
        this.btnNew.setEnabled(false);
        this.btnNew.setLayoutData((Object)new GridData(4, 4, false, false));
        this.btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object wizard = ArgumentsComposite.this.getSelectedEObject() instanceof EClassArgument ? new ChooseEClassWizard(ApogyCoreInvocatorPackage.Literals.ECLASS_ARGUMENT__VALUE, ArgumentsComposite.this.getSelectedEObject(), (EClass)((Argument)ArgumentsComposite.this.getSelectedEObject()).getEParameter().getEType()){

                    public boolean performFinish() {
                        EObject eObject = EcoreUtil.create((EClass)this.getChooseEClassImplementationWizardPage().getSelectedEClass());
                        ApogyCommonTransactionFacade.INSTANCE.basicSet(this.getParent(), (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.ECLASS_ARGUMENT__VALUE, (Object)eObject);
                        ArgumentsComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)eObject));
                        return true;
                    }
                } : new NewChildWizard(ApogyCommonEMFFacade.INSTANCE.getSettableEReferences(ArgumentsComposite.this.getSelectedEObject()), ArgumentsComposite.this.getSelectedEObject()){

                    public boolean performFinish() {
                        EObject eObject = EcoreUtil.create((EClass)this.getSelectedEClass());
                        if (this.getSelectedEReference().isMany()) {
                            ApogyCommonTransactionFacade.INSTANCE.basicAdd(this.getParent(), (EStructuralFeature)this.getSelectedEReference(), (Object)eObject);
                        } else {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet(this.getParent(), (EStructuralFeature)this.getSelectedEReference(), (Object)eObject);
                        }
                        ArgumentsComposite.this.treeViewer.refresh();
                        ArgumentsComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)eObject));
                        return true;
                    }
                };
                WizardDialog dialog = new WizardDialog(ArgumentsComposite.this.getShell(), (IWizard)wizard);
                dialog.open();
            }
        });
        this.btnDelete = new Button(compositeArguments, 0);
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.setLayoutData((Object)new GridData(4, 128, false, false));
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApogyCommonTransactionFacade.INSTANCE.basicDelete(ArgumentsComposite.this.getSelectedEObject().eContainer(), (EStructuralFeature)ArgumentsComposite.this.getSelectedEObject().eContainmentFeature(), (Object)ArgumentsComposite.this.getSelectedEObject());
                ArgumentsComposite.this.treeViewer.refresh();
            }
        });
        this.m_bindingContext = this.initDataBindingsCustom();
    }

    public ArgumentsComposite(Composite parent, int style, boolean emfForms) {
        this(parent, style);
        this.emfForms = emfForms;
        if (emfForms) {
            this.compositeEMFForms = this.getNoSelectionComposite(this, 0);
        }
    }

    private NoContentComposite getNoSelectionComposite(Composite parent, int style) {
        return new NoContentComposite(this, 0){

            protected String getMessage() {
                return "No compatible selection";
            }
        };
    }

    protected void newSelection(ISelection selection) {
    }

    private IPropertyChangeListener getPropertyChangeListener() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ((event.getProperty().equals("TYPED_ELEMENTS_UNITS_ID") || PreferencesConstants.isFormatPreference((String)event.getProperty())) && !ArgumentsComposite.this.treeViewer.isBusy()) {
                        ArgumentsComposite.this.setOperationCall(ArgumentsComposite.this.operationCall);
                    }
                }
            };
        }
        return this.propertyChangeListener;
    }

    public EObject getSelectedEObject() {
        return (EObject)this.treeViewer.getStructuredSelection().getFirstElement();
    }

    public EList<Argument> getArguments() {
        return this.operationCall.getArgumentsList().getArguments();
    }

    public void setOperationCall(OperationCall operationCall) {
        if (this.operationCall != null) {
            this.getAdapter().dispose();
        }
        this.operationCall = operationCall;
        if (this.operationCall.getArgumentsList() != null) {
            EObjectReference eObjectReference = ApogyCommonEMFFactory.eINSTANCE.createEObjectReference();
            eObjectReference.setEObject((EObject)operationCall);
            this.treeViewer.setInput((Object)eObjectReference);
            this.treeViewer.expandAll();
            TreeColumn[] treeColumnArray = this.treeViewer.getTree().getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                column.pack();
                ++n2;
            }
        } else {
            this.treeViewer.setInput(null);
        }
        if (this.operationCall != null) {
            this.getAdapter().init((EObject)this.operationCall);
        }
    }

    protected DataBindingContext initDataBindingsCustom() {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.m_bindingContext = new DataBindingContext();
        this.treeViewer.setContentProvider((IContentProvider)new ArgumentsContentProvider((AdapterFactory)this.adapterFactory));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ArgumentsLabelProvider((AdapterFactory)this.adapterFactory));
        IViewerObservableValue treeViewerSingleSelectionObservableValue = ViewerProperties.singleSelection().observe((Viewer)this.treeViewer);
        ISWTObservableValue btnNewEnabledObserveValue = WidgetProperties.enabled().observe((Widget)this.btnNew);
        this.m_bindingContext.bindValue((IObservableValue)btnNewEnabledObserveValue, (IObservableValue)treeViewerSingleSelectionObservableValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject instanceof EClassArgument && ((EClassArgument)fromObject).getValue() == null) {
                    return true;
                }
                if (fromObject instanceof EObject && !ApogyCommonEMFFacade.INSTANCE.getSettableEReferences((EObject)fromObject).isEmpty()) {
                    return true;
                }
                return false;
            }
        }));
        ISWTObservableValue btnDeleteEnabledObserveValue = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        this.m_bindingContext.bindValue((IObservableValue)btnDeleteEnabledObserveValue, (IObservableValue)treeViewerSingleSelectionObservableValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(EObject.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject == ArgumentsComposite.this.operationCall) {
                    return false;
                }
                if (ArgumentsComposite.this.operationCall.getArgumentsList() != null && ArgumentsComposite.this.operationCall.getArgumentsList().getArguments().indexOf(fromObject) != -1) {
                    return false;
                }
                return true;
            }
        }));
        return this.m_bindingContext;
    }

    public FeaturePathAdapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new FeaturePathAdapterCustomImpl(){

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<EReference> features = new ArrayList<EReference>();
                    features.add(ApogyCoreInvocatorPackage.Literals.OPERATION_CALL__ARGUMENTS_LIST);
                    features.add(ApogyCoreInvocatorPackage.Literals.ARGUMENTS_LIST__ARGUMENTS);
                    features.add(ApogyCoreInvocatorPackage.Literals.ECLASS_ARGUMENT__VALUE);
                    return features;
                }

                public void notifyChanged(Notification msg) {
                    if (!ArgumentsComposite.this.treeViewer.isBusy()) {
                        ArgumentsComposite.this.setOperationCall(ArgumentsComposite.this.operationCall);
                    }
                }
            };
        }
        return this.adapter;
    }

    private class ArgumentsContentProvider
    extends AdapterFactoryContentProvider {
        public ArgumentsContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            if (object instanceof EObjectReference && ((EObjectReference)object).getEObject() instanceof OperationCall) {
                return ((OperationCall)((EObjectReference)object).getEObject()).getArgumentsList().getArguments().toArray();
            }
            return super.getElements(object);
        }

        public Object[] getChildren(Object object) {
            if (object == ArgumentsComposite.this.operationCall) {
                if (((OperationCall)object).getArgumentsList() != null) {
                    return ((OperationCall)object).getArgumentsList().getArguments().toArray();
                }
                Object[] nullObjects = new Object[]{};
                return nullObjects;
            }
            return super.getChildren(object);
        }

        public boolean hasChildren(Object object) {
            if (object == ArgumentsComposite.this.operationCall) {
                return ((OperationCall)object).getArgumentsList() != null;
            }
            return super.hasChildren(object);
        }
    }

    private class ArgumentsEditor
    extends EditingSupport {
        private final String[] booleanLabels;
        private String[] literalsLabels;

        public ArgumentsEditor(ColumnViewer viewer) {
            super(viewer);
            this.booleanLabels = new String[2];
            this.booleanLabels[0] = "true";
            this.booleanLabels[1] = "false";
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof BooleanEDataTypeArgument && (Integer)value != -1) {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)element, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.EDATA_TYPE_ARGUMENT__VALUE, (Object)Arrays.asList(this.booleanLabels).get((Integer)value));
            }
            if (element instanceof StringEDataTypeArgument) {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)element, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.EDATA_TYPE_ARGUMENT__VALUE, value);
            }
            if (element instanceof NumericEDataTypeArgument) {
                double doublevalue = Double.parseDouble(((EDataTypeArgument)element).getValue());
                try {
                    doublevalue = Double.parseDouble((String)value);
                }
                catch (NumberFormatException e) {
                    Logger.warn("setValue(Object element, Object value): Value entered is not a number");
                }
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)element, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.EDATA_TYPE_ARGUMENT__VALUE, (Object)Double.toString(doublevalue));
            }
            if (element instanceof EEnumArgument) {
                EEnum eEnum = ((EEnumArgument)element).getEEnum();
                if ((Integer)value != -1) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)element, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.EENUM_ARGUMENT__EENUM_LITERAL, eEnum.getELiterals().get(((Integer)value).intValue()));
                    ArgumentsComposite.this.treeViewer.refresh();
                }
            }
        }

        protected Object getValue(Object element) {
            if (element instanceof BooleanEDataTypeArgument) {
                return Arrays.asList(this.booleanLabels).indexOf(((EDataTypeArgument)element).getValue());
            }
            if (element instanceof EDataTypeArgument) {
                return ((EDataTypeArgument)element).getValue();
            }
            if (element instanceof EEnumArgument) {
                return Arrays.asList(this.literalsLabels).indexOf(((EEnumArgument)element).getEEnumLiteral().getLiteral());
            }
            return null;
        }

        protected CellEditor getCellEditor(Object element) {
            if (element instanceof EDataTypeArgument) {
                if (element instanceof BooleanEDataTypeArgument) {
                    return new ComboBoxCellEditor((Composite)ArgumentsComposite.this.treeViewer.getTree(), this.booleanLabels);
                }
                if (element instanceof NumericEDataTypeArgument) {
                    return new TextCellEditor((Composite)ArgumentsComposite.this.treeViewer.getTree());
                }
                if (element instanceof StringEDataTypeArgument) {
                    return new TextCellEditor((Composite)ArgumentsComposite.this.treeViewer.getTree());
                }
            }
            if (element instanceof EEnumArgument) {
                EList literals = ((EEnumArgument)element).getEEnum().getELiterals();
                this.literalsLabels = new String[literals.size()];
                int i = 0;
                while (i < literals.size()) {
                    this.literalsLabels[i] = ((EEnumLiteral)literals.get(i)).getLiteral();
                    ++i;
                }
                return new ComboBoxCellEditor((Composite)ArgumentsComposite.this.treeViewer.getTree(), this.literalsLabels);
            }
            return new TextCellEditor((Composite)ArgumentsComposite.this.treeViewer.getTree());
        }

        protected boolean canEdit(Object element) {
            return ArgumentsComposite.this.getArguments().contains(element) && (element instanceof EDataTypeArgument || element instanceof EEnumArgument) && ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)((Argument)element).getEParameter()) == null;
        }
    }

    private class ArgumentsLabelProvider
    extends AdapterFactoryLabelProvider {
        private static final int PARAMETER_COLUMN_ID = 0;
        private static final int VALUE_ID = 1;

        public ArgumentsLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getColumnText(Object object, int columnIndex) {
            String str = "<undefined>";
            switch (columnIndex) {
                case 0: {
                    if (ArgumentsComposite.this.getArguments().contains(object)) {
                        str = super.getColumnText(object, 0);
                        if (!str.contains("(")) break;
                        str = str.substring(0, str.indexOf("("));
                        break;
                    }
                    str = object.getClass().getName();
                    break;
                }
                case 1: {
                    if (ArgumentsComposite.this.getArguments().contains(object)) {
                        if (object instanceof EDataTypeArgument) {
                            EDataTypeArgument argument = (EDataTypeArgument)object;
                            str = argument.getValue();
                            Double valueDouble = 0.0;
                            try {
                                valueDouble = Double.parseDouble(str);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            EParameter param = argument.getEParameter();
                            Unit unit = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)param);
                            if (unit == null) break;
                            if (argument.getValue() == null) {
                                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)argument, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.EDATA_TYPE_ARGUMENT__VALUE, (Object)"0.0");
                            }
                            EOperationEParametersFormatProviderParameters formatParams = ApogyCommonEMFUIFactory.eINSTANCE.createEOperationEParametersFormatProviderParameters();
                            formatParams.setParam(param);
                            EOperationEParametersUnitsProviderParameters unitsParams = ApogyCommonEMFUIFactory.eINSTANCE.createEOperationEParametersUnitsProviderParameters();
                            unitsParams.setParam(param);
                            DecimalFormat format = ApogyCommonEMFUIFacade.INSTANCE.getDisplayFormat(param.getEOperation(), formatParams);
                            Unit displayUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits(param.getEOperation(), unitsParams);
                            Unit nativeUnits = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)param);
                            if (displayUnits != null && !displayUnits.equals((Object)nativeUnits)) {
                                valueDouble = nativeUnits.getConverterTo(displayUnits).convert(valueDouble.doubleValue());
                            }
                            str = String.valueOf(format.format(valueDouble)) + " " + displayUnits.toString();
                            break;
                        }
                        if (object instanceof EClassArgument) {
                            EClassArgument eClassArgumentObject = (EClassArgument)object;
                            if (eClassArgumentObject.getValue() == null) break;
                            str = ((EClassArgument)object).getValue().getClass().getName();
                            break;
                        }
                        if (!(object instanceof EEnumArgument)) break;
                        str = ((EEnumArgument)object).getEEnumLiteral().getLiteral();
                        break;
                    }
                    str = super.getText(object);
                    break;
                }
            }
            return str;
        }
    }
}

