/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.composites;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.EObjectReference;
import org.eclipse.apogy.common.emf.FeaturePathAdapter;
import org.eclipse.apogy.common.emf.impl.FeaturePathAdapterCustomImpl;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.OperationCall;
import org.eclipse.apogy.core.invocator.OperationCallsList;
import org.eclipse.apogy.core.invocator.ui.wizards.OperationCallWizard;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class OperationCallsListComposite
extends ScrolledComposite {
    private DataBindingContext m_currentDataBindings;
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private OperationCallsList operationCallsList;
    private List<FeaturePathAdapter> featurePathAdapters;
    private TableViewer tableViewer;
    private Button btnDelete;
    private Button btnNew;
    private Button btnInvoke;

    public OperationCallsListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, true));
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (OperationCallsListComposite.this.m_currentDataBindings != null) {
                    OperationCallsListComposite.this.m_currentDataBindings.dispose();
                }
                if (OperationCallsListComposite.this.operationCallsList != null) {
                    for (FeaturePathAdapter adapter : OperationCallsListComposite.this.featurePathAdapters) {
                        adapter.dispose();
                    }
                }
            }
        });
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.tableViewer = new TableViewer(composite, 67584);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 4));
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OperationCallsListComposite.this.newSelection(event.getSelection());
            }
        });
        TableColumn tblclmnName = new TableColumn(table, 0);
        tblclmnName.setText("Name");
        TableColumn tblclmnFeature = new TableColumn(table, 0);
        tblclmnFeature.setText("Feature");
        TableColumn tblclmnCommand = new TableColumn(table, 0);
        tblclmnCommand.setText("Command");
        this.btnInvoke = new Button(composite, 0);
        this.btnInvoke.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnInvoke.setText("Invoke");
        this.btnInvoke.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final OperationCall opsCall = (OperationCall)OperationCallsListComposite.this.tableViewer.getStructuredSelection().getFirstElement();
                Job job = new Job(ApogyCoreInvocatorFacade.INSTANCE.getOperationCallString(opsCall)){

                    protected IStatus run(IProgressMonitor monitor) {
                        ApogyCoreInvocatorFacade.INSTANCE.exec(opsCall);
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        });
        Label label = new Label(composite, 258);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnNew = new Button(composite, 0);
        this.btnNew.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnNew.setText("New");
        this.btnNew.setEnabled(false);
        this.btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OperationCallWizard newOperationCallWizard = new OperationCallWizard(OperationCallsListComposite.this.operationCallsList){

                    @Override
                    public boolean performFinish() {
                        this.getOperationCall().eResource().getResourceSet().getResources().remove((Object)this.getOperationCall().eResource());
                        TransactionUtil.disconnectFromEditingDomain((Resource)this.getOperationCall().eResource());
                        OperationCallsListComposite.this.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)OperationCallsListComposite.this.operationCallsList, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.OPERATION_CALL_CONTAINER__OPERATION_CALLS, (Object)this.getOperationCall());
                            }
                        });
                        OperationCallsListComposite.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.getOperationCall()));
                        OperationCallsListComposite.this.packColumns();
                        return true;
                    }
                };
                WizardDialog dialog = new WizardDialog(OperationCallsListComposite.this.getShell(), (IWizard)newOperationCallWizard);
                dialog.open();
            }
        });
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)OperationCallsListComposite.this.operationCallsList, (EStructuralFeature)ApogyCoreInvocatorPackage.Literals.OPERATION_CALL_CONTAINER__OPERATION_CALLS, (Object)OperationCallsListComposite.this.getSelectedOperationCall());
            }
        });
        this.setContent((Control)composite);
        this.setMinSize(composite.computeSize(-1, -1));
        this.m_currentDataBindings = this.initDataBindingsCustom();
    }

    public OperationCall getSelectedOperationCall() {
        return (OperationCall)this.tableViewer.getStructuredSelection().getFirstElement();
    }

    protected void newSelection(ISelection selection) {
    }

    private void packColumns() {
        if (!this.tableViewer.isBusy()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TableColumn[] tableColumnArray = OperationCallsListComposite.this.tableViewer.getTable().getColumns();
                    int n = tableColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableColumn column = tableColumnArray[n2];
                        column.pack();
                        ++n2;
                    }
                }
            });
        }
    }

    protected void refreshViewer() {
        if (!this.tableViewer.isBusy()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    OperationCallsListComposite.this.tableViewer.refresh();
                    OperationCallsListComposite.this.packColumns();
                }
            });
        }
    }

    public void setOperationCallsList(OperationCallsList operationCallsList) {
        if (this.operationCallsList != null) {
            for (FeaturePathAdapter adapter : this.getFeaturePathAdapters()) {
                adapter.dispose();
            }
        }
        this.operationCallsList = operationCallsList;
        if (this.operationCallsList.getOperationCalls() != null) {
            EObjectReference eObjectReference = ApogyCommonEMFFactory.eINSTANCE.createEObjectReference();
            eObjectReference.setEObject((EObject)operationCallsList);
            this.tableViewer.setInput((Object)eObjectReference);
            this.btnNew.setEnabled(true);
            this.packColumns();
        } else {
            this.tableViewer.setInput(null);
        }
        for (FeaturePathAdapter adapter : this.getFeaturePathAdapters()) {
            adapter.init((EObject)operationCallsList);
        }
    }

    public OperationCallsList getOperationCallsList() {
        return this.operationCallsList;
    }

    public void setBackgroudColor(Map<OperationCall, Integer> map) {
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Color color = null;
            if (map.containsKey(item.getData())) {
                color = this.getDisplay().getSystemColor(map.get(item.getData()).intValue());
            }
            if (color == null) {
                color = this.getDisplay().getSystemColor(1);
            }
            item.setBackground(color);
            ++n2;
        }
    }

    private List<FeaturePathAdapter> getFeaturePathAdapters() {
        if (this.featurePathAdapters == null) {
            this.featurePathAdapters = new ArrayList<FeaturePathAdapter>();
            this.featurePathAdapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public void notifyChanged(Notification msg) {
                    OperationCallsListComposite.this.refreshViewer();
                }

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<Object> featurePath = new ArrayList<Object>();
                    featurePath.add(ApogyCoreInvocatorPackage.Literals.OPERATION_CALL_CONTAINER__OPERATION_CALLS);
                    featurePath.add(ApogyCommonEMFPackage.Literals.NAMED__NAME);
                    return featurePath;
                }
            });
            this.featurePathAdapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public void notifyChanged(Notification msg) {
                    OperationCallsListComposite.this.refreshViewer();
                }

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<EReference> featurePath = new ArrayList<EReference>();
                    featurePath.add(ApogyCoreInvocatorPackage.Literals.OPERATION_CALL_CONTAINER__OPERATION_CALLS);
                    featurePath.add(ApogyCoreInvocatorPackage.Literals.OPERATION_CALL__EOPERATION);
                    return featurePath;
                }
            });
            this.featurePathAdapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public void notifyChanged(Notification msg) {
                    OperationCallsListComposite.this.refreshViewer();
                    OperationCallsListComposite.this.newSelection(null);
                }

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<Object> featurePath = new ArrayList<Object>();
                    featurePath.add(ApogyCoreInvocatorPackage.Literals.OPERATION_CALL_CONTAINER__OPERATION_CALLS);
                    featurePath.add(ApogyCoreInvocatorPackage.Literals.VARIABLE_FEATURE_REFERENCE__VARIABLE);
                    featurePath.add(ApogyCommonEMFPackage.Literals.NAMED__NAME);
                    return featurePath;
                }
            });
            this.featurePathAdapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public void notifyChanged(Notification msg) {
                    OperationCallsListComposite.this.refreshViewer();
                    OperationCallsListComposite.this.newSelection(null);
                }

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<EReference> featurePath = new ArrayList<EReference>();
                    featurePath.add(ApogyCoreInvocatorPackage.Literals.OPERATION_CALL_CONTAINER__OPERATION_CALLS);
                    featurePath.add(ApogyCoreInvocatorPackage.Literals.VARIABLE_FEATURE_REFERENCE__FEATURE_ROOT);
                    return featurePath;
                }
            });
            this.featurePathAdapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public void notifyChanged(Notification msg) {
                    OperationCallsListComposite.this.refreshViewer();
                    OperationCallsListComposite.this.newSelection(null);
                }

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<EReference> featurePath = new ArrayList<EReference>();
                    featurePath.add(ApogyCoreInvocatorPackage.Literals.OPERATION_CALL_CONTAINER__OPERATION_CALLS);
                    featurePath.add(ApogyCoreInvocatorPackage.Literals.VARIABLE_FEATURE_REFERENCE__TYPE_MEMBER_REFERENCE_LIST_ELEMENT);
                    return featurePath;
                }
            });
            this.featurePathAdapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public void notifyChanged(Notification msg) {
                    OperationCallsListComposite.this.refreshViewer();
                    OperationCallsListComposite.this.newSelection(null);
                }

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<EReference> featurePath = new ArrayList<EReference>();
                    featurePath.add(ApogyCoreInvocatorPackage.Literals.OPERATION_CALL_CONTAINER__OPERATION_CALLS);
                    featurePath.add(ApogyCoreInvocatorPackage.Literals.OPERATION_CALL__ARGUMENTS_LIST);
                    featurePath.add(ApogyCoreInvocatorPackage.Literals.ARGUMENTS_LIST__ARGUMENTS);
                    return featurePath;
                }
            });
        }
        return this.featurePathAdapters;
    }

    protected DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        this.tableViewer.setContentProvider((IContentProvider)new ControllerBindingsContentProvider((AdapterFactory)this.adapterFactory));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ControllerBindingsLabelProvider((AdapterFactory)this.adapterFactory));
        IViewerObservableValue observeSingleSelectionTableViewer = ViewerProperties.singleSelection().observe((Viewer)this.tableViewer);
        ISWTObservableValue observeEnabledBtnInvokeObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnInvoke);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnInvokeObserveWidget, (IObservableValue)observeSingleSelectionTableViewer, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(OperationCall.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject instanceof OperationCall) {
                    if (Diagnostician.INSTANCE.validate((EObject)fromObject).getSeverity() == 0) {
                        return true;
                    }
                    return false;
                }
                return false;
            }
        }));
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionTableViewer, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        return bindingContext;
    }

    private class ControllerBindingsContentProvider
    extends AdapterFactoryContentProvider {
        public ControllerBindingsContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            if (object instanceof EObjectReference) {
                return ((OperationCallsList)((EObjectReference)object).getEObject()).getOperationCalls().toArray();
            }
            return null;
        }

        public Object[] getChildren(Object object) {
            return null;
        }
    }

    private class ControllerBindingsLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableLabelProvider {
        private static final int NAME_COLUMN_ID = 0;
        private static final int FEATURE_COLUMN_ID = 1;
        private static final int COMMAND_COLUMN_ID = 2;

        public ControllerBindingsLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public String getColumnText(Object object, int columnIndex) {
            String str = "<undefined>";
            if (object instanceof OperationCall) {
                OperationCall operationCall = (OperationCall)object;
                switch (columnIndex) {
                    case 0: {
                        str = operationCall.getName() == null ? "<unnamed>" : operationCall.getName();
                        break;
                    }
                    case 1: {
                        str = ApogyCoreInvocatorFacade.INSTANCE.getOperationCallString(operationCall);
                        if (!str.contains("#")) break;
                        str = str.substring(0, str.indexOf("#"));
                        break;
                    }
                    case 2: {
                        str = ApogyCoreInvocatorFacade.INSTANCE.getEOperationString(operationCall.getArgumentsList(), operationCall.getEOperation());
                        str = str.substring(1, str.length());
                    }
                }
            }
            return str;
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return null;
        }
    }
}

