/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.composites;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.EIdComparator;
import org.eclipse.apogy.core.invocator.Variable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class VariableComboComposite
extends Composite {
    private final List<Variable> variableList = new ArrayList<Variable>();
    private Variable selectedVariable = null;
    private final ComboViewer comboViewer;

    public VariableComboComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.comboViewer = this.createCombo(this, 8);
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    VariableComboComposite.this.newSelection(null);
                } else if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)event.getSelection();
                    if (iStructuredSelection.getFirstElement() instanceof Variable) {
                        VariableComboComposite.this.newSelection((Variable)iStructuredSelection.getFirstElement());
                    } else {
                        VariableComboComposite.this.newSelection(null);
                    }
                }
            }
        });
    }

    private ComboViewer createCombo(Composite parent, int style) {
        ComboViewer comboViewer = new ComboViewer(parent, 12);
        comboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Variable) {
                    Variable variable = (Variable)element;
                    return variable.getName();
                }
                return "";
            }
        });
        comboViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Variable variable1 = (Variable)e1;
                Variable variable2 = (Variable)e2;
                int result = variable1.getName().compareTo(variable2.getName());
                if (result == 0) {
                    EIdComparator comparator = ApogyCommonEMFFactory.eINSTANCE.createEIdComparator();
                    return comparator.compare((Object)variable1, (Object)variable2);
                }
                return result;
            }
        });
        comboViewer.setInput(this.variableList);
        return comboViewer;
    }

    public Variable getSelectedVariable() {
        return this.selectedVariable;
    }

    public void setSelectedVariable(Variable selectedVariable) {
        this.selectedVariable = selectedVariable;
        if (selectedVariable != null) {
            this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)selectedVariable));
        }
    }

    public List<Variable> getVariableList() {
        return this.variableList;
    }

    public void setVariableList(List<Variable> newVariableList) {
        this.variableList.clear();
        if (newVariableList != null) {
            this.variableList.addAll(newVariableList);
        }
        this.comboViewer.setInput(this.variableList);
        if (this.selectedVariable != null) {
            this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedVariable));
        }
    }

    protected void newSelection(Variable variable) {
    }
}

