/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.composites;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.EObjectReference;
import org.eclipse.apogy.common.emf.FeaturePathAdapter;
import org.eclipse.apogy.common.emf.impl.FeaturePathAdapterCustomImpl;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFactory;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.TypeMember;
import org.eclipse.apogy.core.invocator.TypeMemberReferenceListElement;
import org.eclipse.apogy.core.invocator.Variable;
import org.eclipse.apogy.core.invocator.VariableFeatureReference;
import org.eclipse.apogy.core.invocator.VariablesList;
import org.eclipse.apogy.core.invocator.ui.ApogyCoreInvocatorUIFacade;
import org.eclipse.apogy.core.invocator.ui.wizards.VariableWizard;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;

public class VariablesListComposite
extends Composite {
    private final DataBindingContext m_bindingContext;
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private List<FeaturePathAdapter> adapters;
    private final TreeViewer treeViewer;
    private final Button btnDelete;
    private VariablesList variablesList;

    public VariablesListComposite(final Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (VariablesListComposite.this.variablesList != null) {
                    for (FeaturePathAdapter adapter : VariablesListComposite.this.getAdapters()) {
                        adapter.dispose();
                    }
                }
                VariablesListComposite.this.m_bindingContext.dispose();
            }
        });
        this.treeViewer = new TreeViewer((Composite)this, 68098);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        tree.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VariablesListComposite.this.newSelection(event.getSelection());
            }
        });
        TreeViewerColumn treeViewerColumnName = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnName = treeViewerColumnName.getColumn();
        trclmnName.setText("Name");
        trclmnName.setWidth(150);
        TreeViewerColumn treeViewerColumnInterface = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnInterface = treeViewerColumnInterface.getColumn();
        trclmnInterface.setWidth(100);
        trclmnInterface.setText("Interface");
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        Button btnNew = new Button(composite, 0);
        btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new WizardDialog(parent.getShell(), (IWizard)new VariableWizard(VariablesListComposite.this.variablesList)).open();
            }
        });
        btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        btnNew.setSize(74, 29);
        btnNew.setText("New");
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ApogyCoreInvocatorUIFacade.INSTANCE.deleteVariables(VariablesListComposite.this.variablesList, VariablesListComposite.this.getSelectedVariables());
            }
        });
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDelete.setSize(74, 29);
        this.btnDelete.setText("Delete");
        this.m_bindingContext = this.customInitDataBindings();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (VariablesListComposite.this.m_bindingContext != null) {
                    VariablesListComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void newSelection(ISelection selection) {
    }

    public List<Variable> getSelectedVariables() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).toList();
    }

    public VariableFeatureReference getSelectedVariableFeatureReference() {
        VariableFeatureReference variableFeatureReference = ApogyCoreInvocatorFactory.eINSTANCE.createVariableFeatureReference();
        ITreeSelection selection = this.treeViewer.getStructuredSelection();
        if (selection.getFirstElement() instanceof Variable) {
            variableFeatureReference.setVariable((Variable)selection.getFirstElement());
        } else if (selection.getFirstElement() instanceof TypeMember) {
            variableFeatureReference.setVariable((Variable)selection.getPaths()[0].getFirstSegment());
            TypeMemberReferenceListElement typeMemberReferenceListElement = ApogyCoreInvocatorFactory.eINSTANCE.createTypeMemberReferenceListElement();
            typeMemberReferenceListElement.setTypeMember((TypeMember)selection.getPaths()[0].getLastSegment());
            variableFeatureReference.setTypeMemberReferenceListElement(typeMemberReferenceListElement);
        }
        return variableFeatureReference;
    }

    public Variable getSelectedVariable() {
        return (Variable)this.treeViewer.getStructuredSelection().getPaths()[0].getFirstSegment();
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            public Object[] getElements(Object object) {
                return super.getElements((Object)((EObjectReference)object).getEObject());
            }

            public Object[] getChildren(Object object) {
                if (object instanceof Variable) {
                    return ((Variable)object).getVariableType().getMembers().toArray();
                }
                return super.getChildren(object);
            }

            public boolean hasChildren(Object object) {
                if (object instanceof Variable) {
                    Variable variable = (Variable)object;
                    return variable.getVariableType().getMembers().size() > 0;
                }
                return false;
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory){
            private final int NAME_COLUMN_ID = 0;
            private final int INTERFACE_COLUMN_ID = 1;
            {
                this.NAME_COLUMN_ID = 0;
                this.INTERFACE_COLUMN_ID = 1;
            }

            public String getColumnText(Object object, int columnIndex) {
                String str = "<undefined>";
                switch (columnIndex) {
                    case 0: {
                        if (object instanceof Variable) {
                            str = ((Variable)object).getName();
                            break;
                        }
                        if (!(object instanceof TypeMember)) break;
                        str = ((TypeMember)object).getName();
                        break;
                    }
                    case 1: {
                        if (object instanceof Variable) {
                            str = ((Variable)object).getVariableType().getInterfaceClass().getInstanceTypeName();
                            break;
                        }
                        if (!(object instanceof TypeMember)) break;
                        str = ((TypeMember)object).getMemberType().getInterfaceClass().getInstanceClassName();
                        break;
                    }
                }
                return str;
            }
        });
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.treeViewer);
        ISWTObservableValue enabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)enabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        return bindingContext;
    }

    public void setVariablesList(VariablesList variablesList) {
        if (this.variablesList != null) {
            for (FeaturePathAdapter adapter : this.getAdapters()) {
                adapter.dispose();
            }
        }
        this.variablesList = variablesList;
        EObjectReference eObjectReference = ApogyCommonEMFFactory.eINSTANCE.createEObjectReference();
        eObjectReference.setEObject((EObject)variablesList);
        this.treeViewer.setInput((Object)eObjectReference);
        this.treeViewer.expandAll();
        TreeColumn[] treeColumnArray = this.treeViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.pack();
            ++n2;
        }
        Environment env = variablesList.getEnvironment();
        for (FeaturePathAdapter adapter : this.getAdapters()) {
            adapter.init((EObject)env);
        }
    }

    private List<FeaturePathAdapter> getAdapters() {
        if (this.adapters == null) {
            this.adapters = new ArrayList<FeaturePathAdapter>();
            this.adapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public void notifyChanged(Notification msg) {
                    VariablesListComposite.this.treeViewer.refresh();
                    TreeColumn[] treeColumnArray = VariablesListComposite.this.treeViewer.getTree().getColumns();
                    int n = treeColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeColumn test = treeColumnArray[n2];
                        test.pack();
                        ++n2;
                    }
                }

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<EReference> features = new ArrayList<EReference>();
                    features.add(ApogyCoreInvocatorPackage.Literals.ENVIRONMENT__VARIABLES_LIST);
                    features.add(ApogyCoreInvocatorPackage.Literals.VARIABLES_LIST__VARIABLES);
                    return features;
                }
            });
            this.adapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public void notifyChanged(Notification msg) {
                    VariablesListComposite.this.treeViewer.refresh();
                    VariablesListComposite.this.newSelection(null);
                    TreeColumn[] treeColumnArray = VariablesListComposite.this.treeViewer.getTree().getColumns();
                    int n = treeColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeColumn test = treeColumnArray[n2];
                        test.pack();
                        ++n2;
                    }
                }

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<Object> features = new ArrayList<Object>();
                    features.add(ApogyCoreInvocatorPackage.Literals.ENVIRONMENT__ACTIVE_CONTEXT);
                    features.add(ApogyCoreInvocatorPackage.Literals.CONTEXT__VARIABLES_INSTANTIATED);
                    return features;
                }
            });
        }
        return this.adapters;
    }
}

