/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.impl;

import java.util.HashMap;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.core.invocator.ui.ProgramUIFactory;
import org.eclipse.apogy.core.invocator.ui.impl.ProgramUIFactoriesRegistryImpl;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramUIFactoriesRegistryCustomImpl
extends ProgramUIFactoriesRegistryImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ProgramUIFactoriesRegistryImpl.class);

    @Override
    public HashMap<EClass, ProgramUIFactory> getProgramUIFactoriesMap() {
        HashMap<Object, ProgramUIFactory> map = super.getProgramUIFactoriesMap();
        if (this.programUIFactoriesMap == null) {
            map = new HashMap();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(this.getPROGRAM_FACTORY_PROVIDER_CONTRIBUTORS_POINT_ID());
            IConfigurationElement[] contributors = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < contributors.length) {
                IConfigurationElement contributor = contributors[i];
                try {
                    String eClassStr = contributor.getAttribute(this.getPROGRAM_FACTORY_PROVIDER_CONTRIBUTORS_ECLASS_ID());
                    EClass eClass = ApogyCommonEMFFacade.INSTANCE.getEClass(eClassStr);
                    ProgramUIFactory programFactory = (ProgramUIFactory)contributor.createExecutableExtension(this.getPROGRAM_FACTORY_PROVIDER_CONTRIBUTORS_FACTORY_ID());
                    map.put(eClass, programFactory);
                }
                catch (Exception e) {
                    Logger.error("Failed to load contributed ProgramUIFactory from <" + contributor.getClass().getName() + ">", (Throwable)e);
                }
                ++i;
            }
            this.setProgramUIFactoriesMap(map);
        }
        return map;
    }

    @Override
    public ProgramUIFactory getFactory(EClass eClass) {
        return this.getProgramUIFactoriesMap().get(eClass);
    }
}

