/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.renderers;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.inject.Inject;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.Ranges;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.DecimalFormatRegistry;
import org.eclipse.apogy.common.emf.ui.DisplayUnitsRegistry;
import org.eclipse.apogy.common.emf.ui.EOperationEParametersFormatProvider;
import org.eclipse.apogy.common.emf.ui.EOperationEParametersFormatProviderParameters;
import org.eclipse.apogy.common.emf.ui.EOperationEParametersUnitsProvider;
import org.eclipse.apogy.common.emf.ui.EOperationEParametersUnitsProviderParameters;
import org.eclipse.apogy.common.emf.ui.FormatProvider;
import org.eclipse.apogy.common.emf.ui.SimpleFormatProvider;
import org.eclipse.apogy.common.emf.ui.SimpleUnitsProvider;
import org.eclipse.apogy.common.emf.ui.UnitsProvider;
import org.eclipse.apogy.common.emf.ui.emfforms.renderers.AbstractUnitControlCompositeRenderer;
import org.eclipse.apogy.core.invocator.EDataTypeArgument;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EDataTypeArgumentControlCompositeRenderer
extends AbstractUnitControlCompositeRenderer {
    private static final Logger Logger = LoggerFactory.getLogger(EDataTypeArgumentControlCompositeRenderer.class);
    private final EOperationEParametersFormatProviderParameters formatParams = ApogyCommonEMFUIFactory.eINSTANCE.createEOperationEParametersFormatProviderParameters();
    private final EOperationEParametersUnitsProviderParameters unitsParams;

    @Inject
    public EDataTypeArgumentControlCompositeRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.formatParams.setParam(this.getEParameter());
        this.unitsParams = ApogyCommonEMFUIFactory.eINSTANCE.createEOperationEParametersUnitsProviderParameters();
        this.unitsParams.setParam(this.getEParameter());
    }

    protected UpdateValueStrategy getUpdateModelValueStrategy() {
        return new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(String.class, String.class){

            public Object convert(Object fromObject) {
                if (fromObject != null && !"".equals(fromObject)) {
                    try {
                        Number number = ApogyCommonEMFUIFacade.INSTANCE.convertToNativeUnits((Number)Double.parseDouble((String)fromObject), EDataTypeArgumentControlCompositeRenderer.this.getNativeUnits(), EDataTypeArgumentControlCompositeRenderer.this.getDisplayUnits(), EDataTypeArgumentControlCompositeRenderer.this.getTypedElement().getEType());
                        Unit<?> displayUnits = EDataTypeArgumentControlCompositeRenderer.this.getDisplayUnits();
                        Unit<?> nativeUnits = EDataTypeArgumentControlCompositeRenderer.this.getNativeUnits();
                        DecimalFormat format = EDataTypeArgumentControlCompositeRenderer.this.getDecimalFormat();
                        if (displayUnits != null && !displayUnits.equals(nativeUnits)) {
                            EDataTypeArgumentControlCompositeRenderer.this.textValue.setText(format.format(nativeUnits.getConverterTo(displayUnits).convert(number.doubleValue())));
                        } else {
                            EDataTypeArgumentControlCompositeRenderer.this.textValue.setText(format.format(number.doubleValue()));
                        }
                        EClassifier classifier = EDataTypeArgumentControlCompositeRenderer.this.getTypedElement().getEType();
                        if (classifier == EcorePackage.Literals.EFLOAT) {
                            number = Float.valueOf(number.floatValue());
                        } else if (classifier == EcorePackage.Literals.EBYTE) {
                            number = number.byteValue();
                        } else if (classifier == EcorePackage.Literals.ESHORT) {
                            number = number.shortValue();
                        } else if (classifier == EcorePackage.Literals.EINT) {
                            number = number.intValue();
                        } else if (classifier == EcorePackage.Literals.ELONG) {
                            number = number.longValue();
                        }
                        return number.toString();
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)EDataTypeArgumentControlCompositeRenderer.this.textValue.getDisplay().getActiveShell(), (String)"Invalid Number", (String)"The number entered is invalid. The value will be unset.");
                    }
                }
                EDataTypeArgumentControlCompositeRenderer.this.textValue.setText(EDataTypeArgumentControlCompositeRenderer.this.getFormatedValue());
                return EDataTypeArgumentControlCompositeRenderer.this.getValue();
            }
        });
    }

    protected Number getValue() {
        try {
            if (!this.getModelValue().isDisposed() && this.getModelValue().getValue() != null) {
                return NumberFormat.getInstance().parse((String)this.getModelValue().getValue());
            }
            return 0;
        }
        catch (ParseException | DatabindingFailedException e) {
            Logger.error("Error getting the value.");
            return null;
        }
    }

    protected UpdateValueStrategy getUpdateTextValueStrategy() {
        return new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(String.class, String.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    String value = EDataTypeArgumentControlCompositeRenderer.this.getFormatedValue();
                    return value == null ? "" : value;
                }
                return "";
            }
        });
    }

    protected EParameter getEParameter() {
        EObject element = this.getViewModelContext().getDomainModel();
        if (element instanceof EDataTypeArgument) {
            return ((EDataTypeArgument)element).getEParameter();
        }
        return null;
    }

    protected void addToDisplayUnitsRegistry(Unit<?> resultUnits) {
        SimpleUnitsProvider simpleUnitsProvider = ApogyCommonEMFUIFactory.eINSTANCE.createSimpleUnitsProvider();
        simpleUnitsProvider.setUnit(resultUnits);
        UnitsProvider provider = (UnitsProvider)DisplayUnitsRegistry.INSTANCE.getEntriesMap().getEntries().get((Object)this.getEParameter().getEOperation());
        if (provider instanceof EOperationEParametersUnitsProvider) {
            ((EOperationEParametersUnitsProvider)provider).getMap().getEntries().put((Object)this.getEParameter(), (Object)simpleUnitsProvider);
            DisplayUnitsRegistry.INSTANCE.save();
        } else {
            EOperationEParametersUnitsProvider eOpeParamProvider = ApogyCommonEMFUIFactory.eINSTANCE.createEOperationEParametersUnitsProvider();
            eOpeParamProvider.getMap().getEntries().put((Object)this.getEParameter(), (Object)simpleUnitsProvider);
            ApogyCommonEMFUIFacade.INSTANCE.addUnitsProviderToRegistry((ETypedElement)this.getEParameter().getEOperation(), (UnitsProvider)eOpeParamProvider);
        }
    }

    protected void addToDecimalFormatRegistry(DecimalFormat resultFormat) {
        SimpleFormatProvider simpleFormatProvider = ApogyCommonEMFUIFactory.eINSTANCE.createSimpleFormatProvider();
        simpleFormatProvider.setFormatPattern(resultFormat.toPattern());
        FormatProvider provider = (FormatProvider)DecimalFormatRegistry.INSTANCE.getEntriesMap().getEntries().get((Object)this.getEParameter().getEOperation());
        if (provider instanceof EOperationEParametersFormatProvider) {
            ((EOperationEParametersFormatProvider)provider).getMap().getEntries().put((Object)this.getEParameter(), (Object)simpleFormatProvider);
            DecimalFormatRegistry.INSTANCE.save();
        } else {
            EOperationEParametersFormatProvider eOpeParamProvider = ApogyCommonEMFUIFactory.eINSTANCE.createEOperationEParametersFormatProvider();
            eOpeParamProvider.getMap().getEntries().put((Object)this.getEParameter(), (Object)simpleFormatProvider);
            ApogyCommonEMFUIFacade.INSTANCE.addFormatProviderToRegistry((ETypedElement)this.getEParameter().getEOperation(), (FormatProvider)eOpeParamProvider);
        }
    }

    protected Unit<?> getNativeUnits() {
        return ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)this.getEParameter());
    }

    protected Unit<?> getDisplayUnits() {
        Unit units = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits(this.getEParameter().getEOperation(), this.unitsParams);
        if (units == null) {
            units = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)this.getEParameter());
        }
        return units;
    }

    protected DecimalFormat getDecimalFormat() {
        DecimalFormat format = ApogyCommonEMFUIFacade.INSTANCE.getDisplayFormat(this.getEParameter().getEOperation(), this.formatParams);
        if (format == null) {
            format = ApogyCommonEMFUIFacade.INSTANCE.getDisplayFormat((ETypedElement)this.getEParameter());
        }
        return format;
    }

    protected String getFormatedValue() {
        if (this.getValue() != null) {
            Double valueDouble = this.getValue().doubleValue();
            DecimalFormat format = ApogyCommonEMFUIFacade.INSTANCE.getDisplayFormat(this.getEParameter().getEOperation(), this.formatParams);
            Unit displayUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits(this.getEParameter().getEOperation(), this.unitsParams);
            Unit nativeUnits = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)this.getEParameter());
            if (displayUnits != null && !displayUnits.equals((Object)nativeUnits)) {
                valueDouble = nativeUnits.getConverterTo(displayUnits).convert(valueDouble.doubleValue());
            }
            return format.format(valueDouble);
        }
        return "0";
    }

    protected Ranges getRange() {
        return ApogyCommonEMFFacade.INSTANCE.getRange((ETypedElement)this.getEParameter(), (Object)this.getValue());
    }
}

