/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.utils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LongExecutionButtonManager {
    private static final Logger Logger = LoggerFactory.getLogger(LongExecutionButtonManager.class);
    protected Button managedButton = null;
    protected boolean notifyOnCompletion = true;
    protected String operationDescription = null;

    public LongExecutionButtonManager(final Button managedButton, final String operationDescription, final boolean notifyOnCompletion) {
        this.managedButton = managedButton;
        this.operationDescription = operationDescription;
        this.notifyOnCompletion = notifyOnCompletion;
        managedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                managedButton.setEnabled(false);
                Logger.info("Launching execution of " + operationDescription);
                Job job = new Job(operationDescription){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            LongExecutionButtonManager.this.execute();
                            LongExecutionButtonManager.this.postExecuteWithSuccess();
                            if (notifyOnCompletion) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            String message = LongExecutionButtonManager.this.getExecutionSuccessMessage();
                                            Logger.info(message);
                                            MessageDialog.openInformation((Shell)managedButton.getDisplay().getActiveShell(), (String)(String.valueOf(operationDescription) + " Success"), (String)message);
                                        }
                                        catch (Exception e) {
                                            Logger.error(e.getMessage(), (Throwable)e);
                                        }
                                    }
                                });
                            }
                        }
                        catch (Exception e) {
                            LongExecutionButtonManager.this.postExecuteWithError(e);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    String message = LongExecutionButtonManager.this.getExecutionErrorMessage(e);
                                    LongExecutionButtonManager.this.postExecuteWithError(e);
                                    Logger.info(message);
                                    MessageDialog.openError((Shell)managedButton.getDisplay().getActiveShell(), (String)"Error", (String)message);
                                }
                            });
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(30);
                job.schedule();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public String getExecutionSuccessMessage() {
        String message = String.valueOf(this.operationDescription) + " : Completed sucessfully.";
        return message;
    }

    public String getExecutionErrorMessage(Throwable t) {
        String message = "The following error occured during " + this.operationDescription + " : " + t.toString();
        return message;
    }

    public void postExecuteWithSuccess() {
        UIJob uiJob = new UIJob(String.valueOf(this.operationDescription) + "postExecuteWithSuccess()"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (!LongExecutionButtonManager.this.managedButton.isDisposed()) {
                        LongExecutionButtonManager.this.managedButton.setEnabled(true);
                    }
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.schedule();
    }

    public void postExecuteWithError(Throwable t) {
        UIJob uiJob = new UIJob(String.valueOf(this.operationDescription) + "postExecuteWithError(t)"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (!LongExecutionButtonManager.this.managedButton.isDisposed()) {
                        LongExecutionButtonManager.this.managedButton.setEnabled(true);
                    }
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.schedule();
    }

    public abstract void execute() throws Exception;
}

