/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.wizards;

import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.ui.composites.SourceDestinationContextsComposite;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyInitializationDataWizardPage
extends WizardPage {
    private static final Logger Logger = LoggerFactory.getLogger(CopyInitializationDataWizardPage.class);
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.invocator.ui.wizards.CopyInitializationDataWizardPage";
    private SourceDestinationContextsComposite contextsComposite;

    public CopyInitializationDataWizardPage() {
        super(WIZARD_PAGE_ID);
        this.setTitle("Export Apogy Initialization Data");
        this.setDescription("Copy the Initialization Data from a source context to a destination context.");
        this.validate();
    }

    public void createControl(Composite parent) {
        this.contextsComposite = new SourceDestinationContextsComposite(parent, 0){

            @Override
            protected void destinationContextSelected() {
                CopyInitializationDataWizardPage.this.validate();
            }

            @Override
            protected void sourceContextSelected() {
                CopyInitializationDataWizardPage.this.validate();
            }
        };
        this.setControl((Control)this.contextsComposite);
        InvocatorSession invocatorSession = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        if (invocatorSession == null) {
            Logger.error("There is no active session.");
        } else {
            this.contextsComposite.setContextsList(invocatorSession.getEnvironment().getContextsList());
        }
    }

    public Context getSourceContext() {
        return this.contextsComposite == null ? null : this.contextsComposite.getSelectedSourceContext();
    }

    public Context getDestinationContext() {
        return this.contextsComposite == null ? null : this.contextsComposite.getSelectedDestinationContext();
    }

    protected void validate() {
        String message = null;
        if (ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession() == null) {
            message = "There is no active session.";
        } else if (this.getSourceContext() == null) {
            message = "The context source is not defined.";
        } else if (this.getDestinationContext() == null) {
            message = "The context destination is not defined.";
        } else if (this.getSourceContext() == this.getDestinationContext()) {
            message = "Source and destination contexts cannot be the same";
        }
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }
}

