/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.ui.wizards;

import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.VariableImplementation;
import org.eclipse.apogy.core.invocator.VariableImplementationsList;
import org.eclipse.apogy.core.invocator.ui.composites.VariableImplementationsComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class VariableImplementationsWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.invocator.ui.wizards.VariableImplementationsWizardPage";
    private VariableImplementationsComposite variableImplementationsComposite;
    private Adapter adapter;
    private Context context;

    public VariableImplementationsWizardPage() {
        super(WIZARD_PAGE_ID);
        this.setTitle("Variable implementation");
        this.setDescription("Select a variable implementation");
    }

    public VariableImplementationsWizardPage(Context context) {
        this();
        if (this.context != null) {
            this.context.eAdapters().remove((Object)this.getAdapter());
        }
        this.context = context;
        ((VariableImplementation)context.getVariableImplementationsList().getVariableImplementations().get(0)).eAdapters().add((Object)this.getAdapter());
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    VariableImplementationsWizardPage.this.validate();
                }
            };
        }
        return this.adapter;
    }

    public void createControl(Composite parent) {
        this.variableImplementationsComposite = new VariableImplementationsComposite(parent, 0);
        this.variableImplementationsComposite.setContext(this.context);
        this.variableImplementationsComposite.setLayoutData(new GridData(4, 4, true, false));
        this.setControl((Control)this.variableImplementationsComposite);
        this.variableImplementationsComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                VariableImplementationsWizardPage.this.dispose();
            }
        });
        this.validate();
    }

    public void dispose() {
        super.dispose();
        if (this.context != null) {
            this.context.eAdapters().remove((Object)this.getAdapter());
        }
    }

    protected void validate() {
        String errorVariableStr = null;
        VariableImplementationsList variableImplementationsList = this.context.getVariableImplementationsList();
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)variableImplementationsList);
        if (diagnostic.getSeverity() != 0) {
            errorVariableStr = "A variable implementation must be selected";
        }
        this.setErrorMessage(errorVariableStr);
        this.setPageComplete(errorVariableStr == null);
    }
}

