/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.invocator.impl;

import java.util.HashMap;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.core.invocator.ProgramFactory;
import org.eclipse.apogy.core.invocator.impl.ProgramFactoriesRegistryImpl;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramFactoriesRegistryCustomImpl
extends ProgramFactoriesRegistryImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ProgramFactoriesRegistryImpl.class);

    @Override
    public HashMap<EClass, ProgramFactory> getProgramFactoriesMap() {
        HashMap<Object, ProgramFactory> map = super.getProgramFactoriesMap();
        if (this.programFactoriesMap == null) {
            map = new HashMap();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(this.getPROGRAM_FACTORY_PROVIDER_CONTRIBUTORS_POINT_ID());
            IConfigurationElement[] contributors = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < contributors.length) {
                IConfigurationElement contributor = contributors[i];
                try {
                    String eClassStr = contributor.getAttribute(this.getPROGRAM_FACTORY_PROVIDER_CONTRIBUTORS_ECLASS_ID());
                    EClass eClass = ApogyCommonEMFFacade.INSTANCE.getEClass(eClassStr);
                    ProgramFactory programFactory = (ProgramFactory)contributor.createExecutableExtension(this.getPROGRAM_FACTORY_PROVIDER_CONTRIBUTORS_FACTORY_ID());
                    map.put(eClass, programFactory);
                }
                catch (Exception e) {
                    Logger.error("Failed to load contributed ProgramFactory from <" + contributor.getClass().getName() + ">", (Throwable)e);
                }
                ++i;
            }
            this.setProgramFactoriesMap(map);
        }
        return map;
    }

    @Override
    public ProgramFactory getFactory(EClass eClass) {
        return this.getProgramFactoriesMap().get(eClass);
    }
}

