/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.programs.controllers.ui.composite;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.Activator;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EOperationEParametersUnitsProviderParameters;
import org.eclipse.apogy.common.emf.ui.preferences.PreferencesConstants;
import org.eclipse.apogy.common.io.jinput.ApogyCommonIOJInputFactory;
import org.eclipse.apogy.common.io.jinput.EComponent;
import org.eclipse.apogy.common.io.jinput.EComponentQualifier;
import org.eclipse.apogy.common.io.jinput.EControllerEnvironment;
import org.eclipse.apogy.common.io.jinput.EVirtualComponent;
import org.eclipse.apogy.core.programs.controllers.AbstractInputConditioning;
import org.eclipse.apogy.core.programs.controllers.ControllerValueSource;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.ui.RectangleInsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputConditioningComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(InputConditioningComposite.class);
    private Adapter adapter;
    private Adapter eControllerEnvAdapter;
    private AbstractInputConditioning abstractInputConditioning;
    private EComponentQualifier eComponentQualifier;
    private float controllerInput = 0.0f;
    private float controllerOutput = 0.0f;
    private XYSeriesCollection xySeriesCollection;
    private XYSeries xySeries;
    private XYSeries point;
    private JFreeChart chart;
    private IPropertyChangeListener propertyChangeListener;

    public InputConditioningComposite(Composite parent, int style) {
        super(parent, style);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPropertyChangeListener());
        this.setLayout((Layout)new FillLayout());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (InputConditioningComposite.this.abstractInputConditioning != null) {
                    InputConditioningComposite.this.abstractInputConditioning.eAdapters().remove((Object)InputConditioningComposite.this.getAdapter());
                }
                if (InputConditioningComposite.this.eComponentQualifier != null) {
                    org.eclipse.apogy.common.io.jinput.Activator.getEControllerEnvironment().eAdapters().remove((Object)InputConditioningComposite.this.getEControllerEnvAdapter());
                }
                if (InputConditioningComposite.this.propertyChangeListener != null) {
                    Activator.getDefault().getPreferenceStore().removePropertyChangeListener(InputConditioningComposite.this.getPropertyChangeListener());
                }
            }
        });
        this.setSize(200, 200);
        ChartComposite frame = new ChartComposite((Composite)this, 0, this.getChart(), true);
        frame.pack();
        frame.redraw();
    }

    public InputConditioningComposite(Composite parent, int style, AbstractInputConditioning abstractInputConditioning) {
        this(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.setAbstractInputConditioning(abstractInputConditioning);
    }

    public InputConditioningComposite(Composite parent, int style, AbstractInputConditioning abstractInputConditioning, EComponentQualifier eComponentQualifier) {
        this(parent, style, abstractInputConditioning);
        this.setEComponentQualifier(eComponentQualifier);
    }

    protected void checkSubclass() {
    }

    public AbstractInputConditioning getCartesianCoordinatesSet() {
        return this.abstractInputConditioning;
    }

    public void setEComponentQualifier(EComponentQualifier eComponentQualifier) {
        if (this.eComponentQualifier != null) {
            org.eclipse.apogy.common.io.jinput.Activator.getEControllerEnvironment().eAdapters().remove((Object)this.getEControllerEnvAdapter());
        }
        this.eComponentQualifier = eComponentQualifier;
        if (eComponentQualifier != null && eComponentQualifier.getEComponentName() != null && eComponentQualifier.getEControllerName() != null) {
            this.getPoint().clear();
            this.populatePoint();
        }
        org.eclipse.apogy.common.io.jinput.Activator.getEControllerEnvironment().eAdapters().add((Object)this.getEControllerEnvAdapter());
    }

    public void setAbstractInputConditioning(AbstractInputConditioning abstractInputConditioning) {
        if (this.abstractInputConditioning != null) {
            abstractInputConditioning.eAdapters().remove((Object)this.getAdapter());
        }
        this.abstractInputConditioning = abstractInputConditioning;
        if (abstractInputConditioning != null) {
            this.getXYSeries().clear();
            this.populateSeries();
            this.getChart().getXYPlot().getDomainAxis().setAutoRange(true);
            this.getChart().getXYPlot().getRangeAxis().setAutoRange(true);
        }
        String chartYAxisLabel = "Output";
        Unit displayUnits = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)this.getEParameter());
        if (displayUnits != null) {
            chartYAxisLabel = String.valueOf(chartYAxisLabel) + " (" + displayUnits.toString() + ")";
        }
        this.getChart().getXYPlot().getRangeAxis().setLabel(chartYAxisLabel);
        this.abstractInputConditioning.eAdapters().add((Object)this.getAdapter());
    }

    private void updatePlot() {
        if (this.abstractInputConditioning != null) {
            this.getXYSeries().clear();
            this.getPoint().clear();
            this.populatePoint();
            this.populateSeries();
            this.getChart().getXYPlot().getDomainAxis().setAutoRange(true);
            this.getChart().getXYPlot().getRangeAxis().setAutoRange(true);
        }
    }

    protected JFreeChart getChart() {
        if (this.chart == null) {
            String chartTitle = "Output vs Input";
            String chartXAxisLabel = "Input";
            String chartYAxisLabel = "Output";
            this.chart = ChartFactory.createXYLineChart((String)chartTitle, (String)chartXAxisLabel, (String)chartYAxisLabel, (XYDataset)this.getXYSeriesCollection(), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            this.chart.setBackgroundPaint((Paint)Color.white);
            XYPlot plot = (XYPlot)this.chart.getPlot();
            plot.setBackgroundPaint((Paint)Color.white);
            plot.setDomainGridlinePaint((Paint)Color.black);
            plot.setRangeGridlinePaint((Paint)Color.black);
            plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
            plot.setDomainCrosshairVisible(true);
            plot.setRangeCrosshairVisible(true);
            plot.setDomainMinorGridlinesVisible(false);
            plot.setRangeMinorGridlinesVisible(false);
            plot.setDomainGridlinesVisible(true);
            plot.setRangeGridlinesVisible(true);
            XYItemRenderer xyItemRenderer = plot.getRenderer();
            if (xyItemRenderer instanceof XYLineAndShapeRenderer) {
                XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)xyItemRenderer;
                renderer.setBaseShapesVisible(false);
                renderer.setBaseShapesFilled(false);
                renderer.setSeriesShapesVisible(1, true);
                renderer.setSeriesShapesFilled(1, true);
                renderer.setSeriesStroke(0, (Stroke)new BasicStroke(2.0f));
            }
            plot.getRangeAxis().setAutoRange(false);
            plot.getRangeAxis().setRange(-1.0, 1.0);
            plot.getDomainAxis().setAutoRange(true);
        }
        return this.chart;
    }

    public XYSeries getXYSeries() {
        if (this.xySeries == null) {
            String name = new String("");
            this.xySeries = new XYSeries((Comparable)((Object)name), false, true);
        }
        return this.xySeries;
    }

    public XYSeries getPoint() {
        if (this.point == null) {
            this.point = new XYSeries((Comparable)((Object)""), false, true);
            this.point.add(new XYDataItem((double)this.controllerInput, (double)this.controllerOutput));
        }
        return this.point;
    }

    protected XYSeriesCollection getXYSeriesCollection() {
        if (this.xySeriesCollection == null) {
            this.xySeriesCollection = new XYSeriesCollection();
            this.xySeriesCollection.addSeries(this.getXYSeries());
            this.xySeriesCollection.addSeries(this.getPoint());
        }
        return this.xySeriesCollection;
    }

    protected void populatePoint() {
        this.point.add(new XYDataItem((double)this.controllerInput, (double)this.controllerOutput));
    }

    protected void populateSeries() {
        try {
            if (this.abstractInputConditioning != null) {
                EVirtualComponent component = ApogyCommonIOJInputFactory.eINSTANCE.createEVirtualComponent();
                AbstractInputConditioning conditioning = (AbstractInputConditioning)EcoreUtil.copy((EObject)this.abstractInputConditioning);
                float input = -1.0f;
                float inputIncrement = 0.01f;
                float output = 0.0f;
                while (input <= 1.0f) {
                    component.setCurrentValue(input);
                    output = this.convert(conditioning.conditionInput((EComponent)component));
                    this.getXYSeries().add(new XYDataItem((double)input, (double)output));
                    input += inputIncrement;
                }
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeature() != null && !InputConditioningComposite.this.isDisposed()) {
                        InputConditioningComposite.this.controllerInput = 0.0f;
                        InputConditioningComposite.this.controllerOutput = 0.0f;
                        InputConditioningComposite.this.setAbstractInputConditioning(InputConditioningComposite.this.abstractInputConditioning);
                    }
                }
            };
        }
        return this.adapter;
    }

    private Adapter getEControllerEnvAdapter() {
        if (this.eControllerEnvAdapter == null) {
            this.eControllerEnvAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    EComponent component;
                    if (msg.getFeatureID(EControllerEnvironment.class) == 3 && (component = org.eclipse.apogy.common.io.jinput.Activator.getEControllerEnvironment().resolveEComponent(InputConditioningComposite.this.eComponentQualifier)) != null && InputConditioningComposite.this.controllerInput != component.getPollData()) {
                        InputConditioningComposite.this.controllerInput = component.getPollData();
                        InputConditioningComposite.this.controllerOutput = InputConditioningComposite.this.convert(InputConditioningComposite.this.abstractInputConditioning.conditionInput(component));
                        if (!InputConditioningComposite.this.isDisposed()) {
                            InputConditioningComposite.this.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!InputConditioningComposite.this.isDisposed()) {
                                        InputConditioningComposite.this.updatePlot();
                                    }
                                }
                            });
                        }
                    }
                }
            };
        }
        return this.eControllerEnvAdapter;
    }

    private IPropertyChangeListener getPropertyChangeListener() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("TYPED_ELEMENTS_UNITS_ID") || PreferencesConstants.isFormatPreference((String)event.getProperty())) {
                        InputConditioningComposite.this.setAbstractInputConditioning(InputConditioningComposite.this.abstractInputConditioning);
                    }
                }
            };
        }
        return this.propertyChangeListener;
    }

    private EParameter getEParameter() {
        ControllerValueSource valueSource;
        if (this.abstractInputConditioning != null && this.abstractInputConditioning.eContainer() instanceof ControllerValueSource && (valueSource = (ControllerValueSource)this.abstractInputConditioning.eContainer()).getBindedEDataTypeArgument() != null) {
            return valueSource.getBindedEDataTypeArgument().getEParameter();
        }
        return null;
    }

    private float convert(float value) {
        Unit nativeUnit = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)this.getEParameter());
        EOperationEParametersUnitsProviderParameters unitsParams = ApogyCommonEMFUIFactory.eINSTANCE.createEOperationEParametersUnitsProviderParameters();
        unitsParams.setParam(this.getEParameter());
        Unit displayUnit = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits(this.getEParameter().getEOperation(), unitsParams);
        if (displayUnit == null) {
            displayUnit = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)this.getEParameter());
        }
        if (displayUnit != null && nativeUnit != null && displayUnit != nativeUnit) {
            return Double.valueOf(nativeUnit.getConverterTo(displayUnit).convert((double)value)).floatValue();
        }
        return value;
    }
}

