/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.programs.controllers.ui.renderers;

import java.text.DecimalFormat;
import javax.inject.Inject;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.core.invocator.ui.renderers.EDataTypeArgumentControlCompositeRenderer;
import org.eclipse.apogy.core.programs.controllers.ControllerValueSource;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputConditioningControlCompositeRenderer
extends EDataTypeArgumentControlCompositeRenderer {
    private static final Logger Logger = LoggerFactory.getLogger(InputConditioningControlCompositeRenderer.class);

    @Inject
    public InputConditioningControlCompositeRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    protected UpdateValueStrategy getUpdateModelValueStrategy() {
        return new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(String.class, Float.class){

            public Object convert(Object fromObject) {
                if (fromObject != null && !"".equals(fromObject)) {
                    try {
                        Number number = ApogyCommonEMFUIFacade.INSTANCE.convertToNativeUnits((Number)Double.parseDouble((String)fromObject), InputConditioningControlCompositeRenderer.this.getNativeUnits(), InputConditioningControlCompositeRenderer.this.getDisplayUnits(), InputConditioningControlCompositeRenderer.this.getTypedElement().getEType());
                        Unit displayUnits = InputConditioningControlCompositeRenderer.this.getDisplayUnits();
                        Unit nativeUnits = InputConditioningControlCompositeRenderer.this.getNativeUnits();
                        DecimalFormat format = InputConditioningControlCompositeRenderer.this.getDecimalFormat();
                        if (displayUnits != null && !displayUnits.equals((Object)nativeUnits)) {
                            InputConditioningControlCompositeRenderer.this.textValue.setText(format.format(nativeUnits.getConverterTo(displayUnits).convert(number.doubleValue())));
                        } else {
                            InputConditioningControlCompositeRenderer.this.textValue.setText(format.format(number.doubleValue()));
                        }
                        return Float.valueOf(number.floatValue());
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)InputConditioningControlCompositeRenderer.this.textValue.getDisplay().getActiveShell(), (String)"Invalid Number", (String)"The number entered is invalid. The value will be unset.");
                    }
                }
                InputConditioningControlCompositeRenderer.this.textValue.setText(InputConditioningControlCompositeRenderer.this.getFormatedValue());
                return InputConditioningControlCompositeRenderer.this.getValue();
            }
        });
    }

    protected UpdateValueStrategy getUpdateTextValueStrategy() {
        return new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Float.class, String.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    String value = InputConditioningControlCompositeRenderer.this.getFormatedValue();
                    return value == null ? "" : value;
                }
                return "";
            }
        });
    }

    protected Number getValue() {
        try {
            if (!this.getModelValue().isDisposed() && this.getModelValue().getValue() != null) {
                return (Number)this.getModelValue().getValue();
            }
            return 0;
        }
        catch (DatabindingFailedException e) {
            Logger.error("Error getting the value.");
            return null;
        }
    }

    protected EParameter getEParameter() {
        EObject element = this.getViewModelContext().getDomainModel().eContainer();
        if (element instanceof ControllerValueSource) {
            return ((ControllerValueSource)element).getBindedEDataTypeArgument().getEParameter();
        }
        return null;
    }
}

