/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.programs.controllers.impl;

import java.util.List;
import java.util.TreeSet;
import org.eclipse.apogy.common.io.jinput.EComponent;
import org.eclipse.apogy.core.programs.controllers.ApogyCoreProgramsControllersFacade;
import org.eclipse.apogy.core.programs.controllers.InputConditioningPoint;
import org.eclipse.apogy.core.programs.controllers.impl.UserDefinedInputConditioningImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

public class UserDefinedInputConditioningCustomImpl
extends UserDefinedInputConditioningImpl {
    private TreeSet<InputConditioningPoint> sortedPoints = null;
    private Adapter pointsAdapter;

    protected UserDefinedInputConditioningCustomImpl() {
        this.eAdapters().add((Object)this.getPointsAdapter());
    }

    @Override
    public float conditionInput(EComponent component) {
        float rawData = component.getPollData();
        if (this.getSortedPoints().size() > 0) {
            InputConditioningPoint point = ApogyCoreProgramsControllersFacade.INSTANCE.createCustomInputConditioningPoint(rawData, 0.0);
            TreeSet<InputConditioningPoint> sortedSet = this.getSortedPoints();
            InputConditioningPoint low = sortedSet.lower(point);
            InputConditioningPoint high = sortedSet.higher(point);
            if (low != null) {
                if (high != null) {
                    double m = (high.getOutputValue() - low.getOutputValue()) / (high.getInputValue() - low.getInputValue());
                    double b = high.getOutputValue() - m * high.getInputValue();
                    return (float)(m * (double)rawData + b);
                }
                return (float)sortedSet.last().getOutputValue();
            }
            return (float)sortedSet.first().getOutputValue();
        }
        return rawData;
    }

    protected TreeSet<InputConditioningPoint> getSortedPoints() {
        if (this.sortedPoints == null) {
            this.sortedPoints = ApogyCoreProgramsControllersFacade.INSTANCE.sortCustomInputConditioningPoint((List<InputConditioningPoint>)this.getTransferFunction());
        }
        return this.sortedPoints;
    }

    protected Adapter getPointsAdapter() {
        if (this.pointsAdapter == null) {
            this.pointsAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(UserDefinedInputConditioningCustomImpl.class) == 1) {
                        UserDefinedInputConditioningCustomImpl.this.sortedPoints = null;
                    }
                }
            };
        }
        return this.pointsAdapter;
    }
}

