/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.programs.javascript.ui.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Collection;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.programs.javascript.ApogyCoreJavaScriptProgramsFactory;
import org.eclipse.apogy.core.programs.javascript.ApogyJavaScriptFacade;
import org.eclipse.apogy.core.programs.javascript.JavaScriptProgram;
import org.eclipse.apogy.core.programs.javascript.ui.impl.JavaScriptProgramPagesProviderImpl;
import org.eclipse.apogy.core.programs.javascript.ui.wizards.JavaScriptWizardPage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.wizard.WizardPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptProgramPagesProviderCustomImpl
extends JavaScriptProgramPagesProviderImpl {
    private static final Logger Logger = LoggerFactory.getLogger(JavaScriptProgramPagesProviderImpl.class);

    public EObject createEObject(EClass eClass, EClassSettings settings) {
        JavaScriptProgram javaScriptProgram = ApogyCoreJavaScriptProgramsFactory.eINSTANCE.createJavaScriptProgram();
        return javaScriptProgram;
    }

    public EList<WizardPage> instantiateWizardPages(EObject eObject, EClassSettings settings) {
        BasicEList list = new BasicEList();
        list.addAll((Collection)super.instantiateWizardPages(eObject, settings));
        list.add((Object)new JavaScriptWizardPage((JavaScriptProgram)eObject));
        return list;
    }

    public CompoundCommand getPerformFinishCommands(EObject eObject, EClassSettings settings, EditingDomain editingDomain) {
        JavaScriptProgram javaScriptProgram = (JavaScriptProgram)eObject;
        IPath absolutePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(javaScriptProgram.getScriptPath());
        try {
            BufferedReader in = new BufferedReader(new FileReader(absolutePath.toOSString()));
            in.readLine();
            in.close();
        }
        catch (Exception e) {
            try {
                this.populateScript(javaScriptProgram);
            }
            catch (Exception et) {
                Logger.error(et.getMessage(), (Throwable)et);
            }
        }
        return null;
    }

    private void populateScript(JavaScriptProgram javaScriptProgram) throws Exception {
        IPath absolutePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(javaScriptProgram.getScriptPath());
        BufferedWriter out = new BufferedWriter(new FileWriter(absolutePath.toOSString()));
        out.write(ApogyJavaScriptFacade.INSTANCE.createJavaScriptCodeTemplate(ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession(), javaScriptProgram));
        out.close();
    }
}

