/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.topology.ui.composites;

import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.common.topology.AttachedViewPoint;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.NodePath;
import org.eclipse.apogy.common.topology.ui.composites.NodeSearchComposite;
import org.eclipse.apogy.core.ApogyTopology;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyFacade;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class AttachedViewPointComposite
extends Composite {
    private AttachedViewPoint attachedViewPoint;
    private final Button enableRotationButton;
    private final Button enableTranslationButton;
    private DataBindingContext m_bindingContext;
    private final NodeSearchComposite nodeSearchComposite;

    public AttachedViewPointComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public AttachedViewPointComposite(Composite parent, int style, final AttachedViewPoint attachedViewPoint) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        Composite top = new Composite((Composite)this, 2048);
        top.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        top.setLayout((Layout)new GridLayout(4, true));
        Label lblEnableRotationLabel = new Label(top, 0);
        lblEnableRotationLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblEnableRotationLabel.setText("Enable Rotation:");
        this.enableRotationButton = new Button(top, 32);
        Label lblEnableTranslationLabel = new Label(top, 0);
        lblEnableTranslationLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblEnableTranslationLabel.setText("Enable Translation:");
        this.enableTranslationButton = new Button(top, 32);
        Composite bottom = new Composite((Composite)this, 0);
        bottom.setLayout((Layout)new GridLayout(1, false));
        bottom.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.nodeSearchComposite = new NodeSearchComposite(bottom, 2048){

            public void nodeSelectedChanged(Node nodeSelected) {
                GroupNode root = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology().getRootNode();
                NodePath nodePath = ApogyCommonTopologyFacade.INSTANCE.createNodePath((Node)root, nodeSelected);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)attachedViewPoint, (EStructuralFeature)ApogyCommonTopologyPackage.Literals.ATTACHED_VIEW_POINT__NODE_PATH, (Object)nodePath);
            }
        };
        this.nodeSearchComposite.setTopologyRoot(this.resolveTopologyRoot());
        this.setAttachedViewPoint(attachedViewPoint);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AttachedViewPointComposite.this.m_bindingContext != null) {
                    AttachedViewPointComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public AttachedViewPoint getAttachedViewPoint() {
        return this.attachedViewPoint;
    }

    public void setAttachedViewPoint(AttachedViewPoint attachedViewPoint) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.attachedViewPoint = attachedViewPoint;
        if (attachedViewPoint != null) {
            this.m_bindingContext = this.initDataBindingsCustom();
        }
    }

    private Node resolveTopologyRoot() {
        ApogyTopology apogyTopology = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology();
        if (apogyTopology != null) {
            return apogyTopology.getRootNode();
        }
        return null;
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        IObservableValue observeAllowRotation = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.attachedViewPoint), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonTopologyPackage.Literals.ATTACHED_VIEW_POINT__ALLOW_ROTATION})).observe((Object)this.attachedViewPoint);
        ISWTObservableValue observeEnableRotationButton = WidgetProperties.selection().observe((Widget)this.enableRotationButton);
        bindingContext.bindValue((IObservableValue)observeEnableRotationButton, observeAllowRotation, new UpdateValueStrategy(), new UpdateValueStrategy());
        IObservableValue observeAllowTranslation = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.attachedViewPoint), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonTopologyPackage.Literals.ATTACHED_VIEW_POINT__ALLOW_TRANSLATION})).observe((Object)this.attachedViewPoint);
        ISWTObservableValue observeEnableTranslationButton = WidgetProperties.selection().observe((Widget)this.enableTranslationButton);
        bindingContext.bindValue((IObservableValue)observeEnableTranslationButton, observeAllowTranslation, new UpdateValueStrategy(), new UpdateValueStrategy());
        return bindingContext;
    }
}

