/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.composites;

import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.MapBasedEClassSettings;
import org.eclipse.apogy.common.emf.ui.wizards.ApogyEObjectWizard;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.AssemblyLink;
import org.eclipse.apogy.core.AssemblyLinksList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class AssemblyLinkListComposite
extends Composite {
    private AssemblyLinksList assemblyLinksList;
    private final Tree tree;
    private final TreeViewer treeViewer;
    private final Button btnNew;
    private final Button btnDelete;
    private DataBindingContext m_bindingContext;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public AssemblyLinkListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer((Composite)this, 68354);
        this.tree = this.treeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, true, true, 1, 1);
        gd_tree.widthHint = 200;
        gd_tree.minimumWidth = 200;
        this.tree.setLayoutData((Object)gd_tree);
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new AssemblyLinksListContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object object = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (object instanceof AssemblyLink) {
                    AssemblyLink selectedAssemblyLink = (AssemblyLink)object;
                    AssemblyLinkListComposite.this.newAssemblyLinkSelected(selectedAssemblyLink);
                }
            }
        });
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.btnNew = new Button(composite, 0);
        this.btnNew.setSize(74, 29);
        this.btnNew.setText("New");
        this.btnNew.setToolTipText("Create a new Assembly Link.");
        this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNew.setEnabled(true);
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    MapBasedEClassSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createMapBasedEClassSettings();
                    String name = ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)AssemblyLinkListComposite.this.getAssemblyLinksList(), null, (ETypedElement)ApogyCorePackage.Literals.ASSEMBLY_LINKS_LIST__ASSEMBLY_LINKS);
                    settings.getUserDataMap().put("name", name);
                    ApogySystem apogySystem = (ApogySystem)AssemblyLinkListComposite.this.getAssemblyLinksList().eContainer();
                    settings.getUserDataMap().put("apogySystem", apogySystem);
                    ApogyEObjectWizard wizard = new ApogyEObjectWizard(ApogyCorePackage.Literals.ASSEMBLY_LINKS_LIST__ASSEMBLY_LINKS, (EObject)AssemblyLinkListComposite.this.getAssemblyLinksList(), (EClassSettings)settings, ApogyCorePackage.Literals.ASSEMBLY_LINK);
                    WizardDialog dialog = new WizardDialog(AssemblyLinkListComposite.this.getShell(), (IWizard)wizard);
                    dialog.open();
                    if (!AssemblyLinkListComposite.this.treeViewer.isBusy()) {
                        AssemblyLinkListComposite.this.treeViewer.refresh();
                    }
                }
            }
        });
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDelete.setSize(74, 29);
        this.btnDelete.setText("Delete");
        this.btnDelete.setToolTipText("Deletes the selected Assembly Link(s).");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String deleteMessage = "";
                Iterator<AssemblyLink> assemblyLinkIterator = AssemblyLinkListComposite.this.getSelectedAssemblyLinks().iterator();
                while (assemblyLinkIterator.hasNext()) {
                    AssemblyLink assemblyLink = assemblyLinkIterator.next();
                    deleteMessage = String.valueOf(deleteMessage) + assemblyLink.getName();
                    if (!assemblyLinkIterator.hasNext()) continue;
                    deleteMessage = String.valueOf(deleteMessage) + ", ";
                }
                MessageDialog dialog = new MessageDialog(null, "Delete the selected Assembly Link(s)", null, "Are you sure to delete these Assembly Link(s) : " + deleteMessage, 3, new String[]{"Yes", "No"}, 1);
                int result = dialog.open();
                if (result == 0) {
                    List<AssemblyLink> toRemove = AssemblyLinkListComposite.this.getSelectedAssemblyLinks();
                    ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)AssemblyLinkListComposite.this.getAssemblyLinksList(), (EStructuralFeature)ApogyCorePackage.Literals.ASSEMBLY_LINKS_LIST__ASSEMBLY_LINKS, toRemove);
                }
                if (!AssemblyLinkListComposite.this.treeViewer.isBusy()) {
                    AssemblyLinkListComposite.this.treeViewer.refresh();
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AssemblyLinkListComposite.this.m_bindingContext != null) {
                    AssemblyLinkListComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public AssemblyLinksList getAssemblyLinksList() {
        return this.assemblyLinksList;
    }

    public void setAssemblyLinksList(AssemblyLinksList newAssemblyLinksList) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.assemblyLinksList = newAssemblyLinksList;
        if (newAssemblyLinksList != null) {
            this.m_bindingContext = this.initDataBindingsCustom();
        }
        this.treeViewer.setInput((Object)newAssemblyLinksList);
    }

    public List<AssemblyLink> getSelectedAssemblyLinks() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).toList();
    }

    protected void newAssemblyLinkSelected(AssemblyLink selectedAssemblyLink) {
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.treeViewer);
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        return bindingContext;
    }

    private class AssemblyLinksListContentProvider
    implements ITreeContentProvider {
        private AssemblyLinksListContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof AssemblyLinksList) {
                AssemblyLinksList assemblyLinksList = (AssemblyLinksList)inputElement;
                return assemblyLinksList.getAssemblyLinks().toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof AssemblyLinksList) {
                AssemblyLinksList assemblyLinksList = (AssemblyLinksList)parentElement;
                return assemblyLinksList.getAssemblyLinks().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof AssemblyLinksList) {
                AssemblyLinksList assemblyLinksList = (AssemblyLinksList)element;
                return !assemblyLinksList.getAssemblyLinks().isEmpty();
            }
            return false;
        }
    }
}

