/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.ui.wizards;

import java.util.Collection;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.AssemblyLink;
import org.eclipse.apogy.core.ConnectionPoint;
import org.eclipse.apogy.core.ConnectionPointsList;
import org.eclipse.apogy.core.invocator.TypeMember;
import org.eclipse.apogy.core.ui.wizards.AbstractAssemblyLinkWizardPage;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;

public class AssemblyLinkSourceWizardPage
extends AbstractAssemblyLinkWizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.ui.wizards.AssemblyLinkConnectivityWizardPage";
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private Tree parentSystemTree;
    private TreeViewer parentSystemTreeViewer;
    private TypeMember selectedParentSystem = null;
    private Tree parentConnectionPointTree;
    private TreeViewer parentConnectionPointTreeViewer;
    private ConnectionPoint selectedConnectionPoint = null;

    public AssemblyLinkSourceWizardPage(ApogySystem apogySystem, AssemblyLink assemblyLink) {
        super(WIZARD_PAGE_ID, apogySystem, assemblyLink);
        this.setTitle("Assembly link parent");
        this.setDescription("Set the parent system and connection point.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, true));
        this.setControl((Control)container);
        Group parentSystemGroup = new Group(container, 2048);
        parentSystemGroup.setLayout((Layout)new FillLayout());
        parentSystemGroup.setText("Parent System");
        parentSystemGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createParentSystemComposite((Composite)parentSystemGroup);
        Group parentConnectionPointGroup = new Group(container, 2048);
        parentConnectionPointGroup.setLayout((Layout)new FillLayout());
        parentConnectionPointGroup.setText("Parent Connection Point");
        parentConnectionPointGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createParentConnectionPointComposite((Composite)parentConnectionPointGroup);
    }

    private Composite createParentSystemComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.parentSystemTreeViewer = new TreeViewer(container, 68354);
        this.parentSystemTree = this.parentSystemTreeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, false, true, 2, 1);
        gd_tree.widthHint = 200;
        gd_tree.minimumWidth = 200;
        this.parentSystemTree.setLayoutData((Object)gd_tree);
        this.parentSystemTree.setLinesVisible(true);
        this.parentSystemTreeViewer.setContentProvider((IContentProvider)new ApogySystemContentProvider());
        this.parentSystemTreeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.parentSystemTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AssemblyLinkSourceWizardPage.this.selectedParentSystem = (TypeMember)((IStructuredSelection)event.getSelection()).getFirstElement();
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)AssemblyLinkSourceWizardPage.this.assemblyLink, (EStructuralFeature)ApogyCorePackage.Literals.ASSEMBLY_LINK__PARENT_TYPE_MEMBER, (Object)AssemblyLinkSourceWizardPage.this.selectedParentSystem, true);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)AssemblyLinkSourceWizardPage.this.assemblyLink, (EStructuralFeature)ApogyCorePackage.Literals.ASSEMBLY_LINK__PARENT_CONNECTION_POINT, null, true);
                if (AssemblyLinkSourceWizardPage.this.selectedParentSystem != null && AssemblyLinkSourceWizardPage.this.selectedParentSystem.getMemberType() instanceof ApogySystem) {
                    ApogySystem system = (ApogySystem)AssemblyLinkSourceWizardPage.this.selectedParentSystem.getMemberType();
                    AssemblyLinkSourceWizardPage.this.parentConnectionPointTreeViewer.setInput((Object)system.getConnectionPointsList());
                } else {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)AssemblyLinkSourceWizardPage.this.assemblyLink, (EStructuralFeature)ApogyCorePackage.Literals.ASSEMBLY_LINK__PARENT_TYPE_MEMBER, null, true);
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)AssemblyLinkSourceWizardPage.this.assemblyLink, (EStructuralFeature)ApogyCorePackage.Literals.ASSEMBLY_LINK__PARENT_CONNECTION_POINT, null, true);
                    AssemblyLinkSourceWizardPage.this.parentConnectionPointTreeViewer.setInput((Object)AssemblyLinkSourceWizardPage.this.apogySystem.getConnectionPointsList());
                }
                AssemblyLinkSourceWizardPage.this.validate();
            }
        });
        this.parentSystemTreeViewer.setInput(this.getAllTypeMembers(this.apogySystem));
        Button btnClearParentSystem = new Button(container, 0);
        btnClearParentSystem.setSize(74, 29);
        btnClearParentSystem.setText("This");
        btnClearParentSystem.setToolTipText("Sets the parent system for the Assembly Link to this system.");
        btnClearParentSystem.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        btnClearParentSystem.setEnabled(true);
        btnClearParentSystem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AssemblyLinkSourceWizardPage.this.parentSystemTreeViewer.setSelection((ISelection)new StructuredSelection(), true);
                AssemblyLinkSourceWizardPage.this.validate();
            }
        });
        return container;
    }

    private Composite createParentConnectionPointComposite(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.parentConnectionPointTreeViewer = new TreeViewer(container, 68354);
        this.parentConnectionPointTree = this.parentConnectionPointTreeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, true, true, 1, 1);
        gd_tree.widthHint = 200;
        gd_tree.minimumWidth = 200;
        this.parentConnectionPointTree.setLayoutData((Object)gd_tree);
        this.parentConnectionPointTree.setLinesVisible(true);
        this.parentConnectionPointTreeViewer.setContentProvider((IContentProvider)new ConnectionPointsContentProvider());
        this.parentConnectionPointTreeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.parentConnectionPointTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AssemblyLinkSourceWizardPage.this.selectedConnectionPoint = (ConnectionPoint)((IStructuredSelection)event.getSelection()).getFirstElement();
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)AssemblyLinkSourceWizardPage.this.assemblyLink, (EStructuralFeature)ApogyCorePackage.Literals.ASSEMBLY_LINK__PARENT_CONNECTION_POINT, (Object)AssemblyLinkSourceWizardPage.this.selectedConnectionPoint, true);
                AssemblyLinkSourceWizardPage.this.validate();
            }
        });
        this.parentConnectionPointTreeViewer.setInput((Object)this.apogySystem.getConnectionPointsList());
        return container;
    }

    protected void validate() {
        String errorMessage = null;
        if (this.assemblyLink.getParentConnectionPoint() == null) {
            errorMessage = "No Parent Connections Point specified !";
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private class ApogySystemContentProvider
    implements ITreeContentProvider {
        private ApogySystemContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                Collection collection = (Collection)inputElement;
                return collection.toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Collection) {
                Collection collection = (Collection)parentElement;
                return collection.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Collection) {
                Collection collection = (Collection)element;
                return collection.isEmpty();
            }
            return false;
        }
    }

    private class ConnectionPointsContentProvider
    implements ITreeContentProvider {
        private ConnectionPointsContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ConnectionPointsList) {
                ConnectionPointsList connectionPointsList = (ConnectionPointsList)inputElement;
                return connectionPointsList.getConnectionPoints().toArray();
            }
            if (inputElement instanceof Collection) {
                Collection collection = (Collection)inputElement;
                return collection.toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ConnectionPointsList) {
                ConnectionPointsList connectionPointsList = (ConnectionPointsList)parentElement;
                return connectionPointsList.getConnectionPoints().toArray();
            }
            if (parentElement instanceof Collection) {
                Collection collection = (Collection)parentElement;
                return collection.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ConnectionPointsList) {
                ConnectionPointsList connectionPointsList = (ConnectionPointsList)element;
                return !connectionPointsList.getConnectionPoints().isEmpty();
            }
            if (element instanceof Collection) {
                Collection collection = (Collection)element;
                return !collection.isEmpty();
            }
            return false;
        }
    }
}

