/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.impl;

import javax.vecmath.Matrix4d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.core.AbstractApogySystemPoseCorrector;
import org.eclipse.apogy.core.ApogyCoreFacade;
import org.eclipse.apogy.core.ApogyCoreFactory;
import org.eclipse.apogy.core.ApogyInitializationData;
import org.eclipse.apogy.core.OperationCallPositionedResult;
import org.eclipse.apogy.core.impl.ApogySystemApiAdapterImpl;
import org.eclipse.apogy.core.invocator.AbstractInitializationData;
import org.eclipse.apogy.core.invocator.OperationCall;
import org.eclipse.apogy.core.invocator.OperationCallResult;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ApogySystemApiAdapterCustomImpl
extends ApogySystemApiAdapterImpl {
    private Matrix4x4 lastRawPose = null;

    @Override
    public void setPoseTransform(Matrix4x4 newPoseTransform) {
        this.lastRawPose = newPoseTransform;
        if (this.getPoseCorrector() != null) {
            Matrix4x4 correctedPose = this.getPoseCorrector().applyCorrection(newPoseTransform);
            super.setPoseTransform(correctedPose);
        } else {
            super.setPoseTransform(newPoseTransform);
        }
    }

    @Override
    public void setPoseCorrector(AbstractApogySystemPoseCorrector newPoseCorrector) {
        super.setPoseCorrector(newPoseCorrector);
        this.setPoseTransform(this.lastRawPose);
    }

    public OperationCallResult createResult(OperationCall operationCall) {
        return ApogyCoreFactory.eINSTANCE.createOperationCallPositionedResult();
    }

    @Override
    public Matrix4x4 createResultMatrix(OperationCall operationCall) {
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        return ApogyCommonMathFacade.INSTANCE.createMatrix4x4(m);
    }

    public OperationCallResult createResult(OperationCall operationCall, long invocationTime, Object resultValue, Exception exception) {
        OperationCallPositionedResult result = (OperationCallPositionedResult)super.createResult(operationCall, invocationTime, resultValue, exception);
        Matrix4x4 relativePose = this.createResultMatrix(operationCall);
        Matrix4x4 absolutePose = ApogyCoreFacade.INSTANCE.computeAbsolutePoseMatrix(this.getApogySystem(), relativePose);
        result.setRelativePose(relativePose);
        result.setPose(absolutePose);
        if (operationCall.getName() != null && operationCall.getName().length() > 0) {
            result.setName(operationCall.getName());
        } else {
            result.setName(operationCall.getEOperation().getName());
        }
        if (operationCall.getDescription() != null && operationCall.getDescription().length() > 0) {
            result.setDescription(operationCall.getDescription());
        }
        return result;
    }

    public void apply(AbstractInitializationData initializationData) {
        super.apply(initializationData);
        if (initializationData instanceof ApogyInitializationData) {
            ApogyInitializationData data = (ApogyInitializationData)initializationData;
            this.setPoseTransform((Matrix4x4)EcoreUtil.copy((EObject)data.getInitialPoseTransform()));
        }
    }

    public AbstractInitializationData createInitializationData() {
        return ApogyCoreFactory.eINSTANCE.createApogyInitializationData();
    }

    public void collect(AbstractInitializationData data) {
        super.collect(data);
        ApogyInitializationData apogyInitializationData = (ApogyInitializationData)data;
        apogyInitializationData.setInitialPoseTransform((Matrix4x4)EcoreUtil.copy((EObject)this.getPoseTransform()));
    }
}

