/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.mobile_platform.apogy.impl;

import org.eclipse.apogy.addons.vehicle.ApogyAddonsVehicleFactory;
import org.eclipse.apogy.addons.vehicle.ApogySystemVehiclePoseCorrector;
import org.eclipse.apogy.addons.vehicle.ContactProvider;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.core.AbstractApogySystemPoseCorrector;
import org.eclipse.apogy.core.invocator.AbstractInitializationData;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.Type;
import org.eclipse.apogy.examples.mobile_platform.ApogyExamplesMobilePlatformFactory;
import org.eclipse.apogy.examples.mobile_platform.MobilePlatform;
import org.eclipse.apogy.examples.mobile_platform.Position;
import org.eclipse.apogy.examples.mobile_platform.apogy.ApogyExamplesMobilePlatformApogyFactory;
import org.eclipse.apogy.examples.mobile_platform.apogy.MobilePlatformData;
import org.eclipse.apogy.examples.mobile_platform.apogy.impl.MobilePlatformApogySystemApiAdapterImpl;
import org.eclipse.apogy.examples.mobile_platform.apogy.impl.PositionAdapter;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;

public class MobilePlatformApogySystemApiAdapterCustomImpl
extends MobilePlatformApogySystemApiAdapterImpl {
    private Adapter positionAdapter = null;

    protected MobilePlatform getMobilePlatform() {
        return (MobilePlatform)this.getInstance();
    }

    public void init(Environment environment, Type elementType, EObject instance) {
        super.init(environment, elementType, instance);
        this.positionAdapter = new PositionAdapter(this);
        this.getMobilePlatform().eAdapters().add((Object)this.positionAdapter);
        ApogySystemVehiclePoseCorrector corrector = ApogyAddonsVehicleFactory.eINSTANCE.createApogySystemVehiclePoseCorrector();
        corrector.setContactProvider((ContactProvider)ApogyAddonsVehicleFactory.eINSTANCE.createWheelContactProvider());
        this.setPoseCorrector((AbstractApogySystemPoseCorrector)corrector);
    }

    public void dispose() {
        if (this.getMobilePlatform() != null) {
            this.getMobilePlatform().eAdapters().remove((Object)this.positionAdapter);
            if (this.getMobilePlatform().getPosition() != null) {
                this.getMobilePlatform().getPosition().eAdapters().remove((Object)this.positionAdapter);
            }
            this.getMobilePlatform().dispose();
        }
        this.setPoseCorrector(null);
        super.dispose();
    }

    public AbstractInitializationData createInitializationData() {
        return ApogyExamplesMobilePlatformApogyFactory.eINSTANCE.createMobilePlatformData();
    }

    public void apply(AbstractInitializationData initializationData) {
        super.apply(initializationData);
        if (initializationData instanceof MobilePlatformData) {
            MobilePlatformData mobilePlatformData = (MobilePlatformData)initializationData;
            if (!mobilePlatformData.isInitialized() && this.getMobilePlatform().isInitialized() || !mobilePlatformData.isDisposed() && this.getMobilePlatform().isDisposed()) {
                String message = "The given initialization data cannot be applied to this mobile platform; the given init data says that the platform should not be initialized or disposed, when it already is in that state.";
                throw new RuntimeException(message);
            }
            if (mobilePlatformData.isInitialized()) {
                Matrix4x4 matrix;
                if (!this.getMobilePlatform().isInitialized()) {
                    this.getMobilePlatform().init();
                }
                if ((matrix = mobilePlatformData.getInitialPoseTransform()) == null) {
                    matrix = ApogyCommonMathFacade.INSTANCE.createIdentityMatrix4x4();
                }
                Tuple3d position = ApogyCommonMathFacade.INSTANCE.extractPosition(matrix);
                Tuple3d orientation = ApogyCommonMathFacade.INSTANCE.extractOrientation(matrix);
                Position newPlatformPosition = ApogyExamplesMobilePlatformFactory.eINSTANCE.createPosition();
                newPlatformPosition.setX(position.getX());
                newPlatformPosition.setY(position.getY());
                newPlatformPosition.setTheta(orientation.getZ());
                this.getMobilePlatform().resetPosition(newPlatformPosition);
                this.getMobilePlatform().cmdVelocities(mobilePlatformData.getLinearVelocity(), mobilePlatformData.getAngularVelocity());
            }
            if (mobilePlatformData.isDisposed() && !this.getMobilePlatform().isDisposed()) {
                this.getMobilePlatform().dispose();
            }
        }
    }

    public void collect(AbstractInitializationData initializationData) {
        super.collect(initializationData);
        if (initializationData instanceof MobilePlatformData) {
            MobilePlatformData mobilePlatformData = (MobilePlatformData)initializationData;
            mobilePlatformData.setInitialPoseTransform(this.getPoseTransform());
            mobilePlatformData.setInitialized(this.getMobilePlatform().isInitialized());
            mobilePlatformData.setDisposed(this.getMobilePlatform().isDisposed());
            mobilePlatformData.setLinearVelocity(this.getMobilePlatform().getLinearVelocity());
            mobilePlatformData.setAngularVelocity(this.getMobilePlatform().getAngularVelocity());
        }
    }
}

