/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.robotic_arm.apogy.impl;

import javax.vecmath.Matrix4d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.core.invocator.AbstractInitializationData;
import org.eclipse.apogy.core.invocator.OperationCall;
import org.eclipse.apogy.examples.robotic_arm.RoboticArm;
import org.eclipse.apogy.examples.robotic_arm.apogy.ApogyExamplesRoboticArmApogyFactory;
import org.eclipse.apogy.examples.robotic_arm.apogy.RoboticArmData;
import org.eclipse.apogy.examples.robotic_arm.apogy.impl.RoboticArmApogySystemApiAdapterImpl;

public class RoboticArmApogySystemApiAdapterCustomImpl
extends RoboticArmApogySystemApiAdapterImpl {
    protected RoboticArm getRoboticArm() {
        return (RoboticArm)this.getInstance();
    }

    public Matrix4x4 createResultMatrix(OperationCall operationCall) {
        if (operationCall.getEOperation().getOperationID() == 2) {
            Node tip = (Node)ApogyCommonTopologyFacade.INSTANCE.findNodesByID("ROBOTIC_ARM_SYM_SYS_HAND_TIP", this.getApogySystem().getTopologyRoot().getOriginNode()).get(0);
            Node root = (Node)ApogyCommonTopologyFacade.INSTANCE.findNodesByID("ROBOTIC_ARM_SYM_SYS_ROOT", this.getApogySystem().getTopologyRoot().getOriginNode()).get(0);
            Matrix4d matrix4d = ApogyCommonTopologyFacade.INSTANCE.expressInFrame(tip, root);
            return ApogyCommonMathFacade.INSTANCE.createMatrix4x4(matrix4d);
        }
        return super.createResultMatrix(operationCall);
    }

    public AbstractInitializationData createInitializationData() {
        return ApogyExamplesRoboticArmApogyFactory.eINSTANCE.createRoboticArmData();
    }

    public void apply(AbstractInitializationData initializationData) {
        super.apply(initializationData);
        if (this.getRoboticArm() == null) {
            return;
        }
        if (initializationData instanceof RoboticArmData) {
            RoboticArmData roboticArmData = (RoboticArmData)initializationData;
            if (roboticArmData.isInitialized()) {
                if (!this.getRoboticArm().isInitialized()) {
                    this.getRoboticArm().init();
                }
                this.getRoboticArm().cmdMoveSpeedLevel(roboticArmData.getSpeed());
                this.getRoboticArm().moveTo(Math.toRadians(roboticArmData.getTurretAngle()), Math.toRadians(roboticArmData.getShoulderAngle()), Math.toRadians(roboticArmData.getElbowAngle()), Math.toRadians(roboticArmData.getWristAngle()));
            } else if (this.getRoboticArm().isInitialized()) {
                String message = "The given initialization data cannot be applied to this robotic arm; the given init data says that the arm should not be initialized , when it already is in that state.";
                throw new RuntimeException(message);
            }
        }
    }

    public void collect(AbstractInitializationData initializationData) {
        super.collect(initializationData);
        if (this.getRoboticArm() == null) {
            return;
        }
        if (initializationData instanceof RoboticArmData) {
            RoboticArmData roboticArmData = (RoboticArmData)initializationData;
            roboticArmData.setInitialized(this.getRoboticArm().isInitialized());
            roboticArmData.setSpeed(this.getRoboticArm().getSpeed());
            roboticArmData.setElbowAngle(this.getRoboticArm().getElbowAngle());
            roboticArmData.setShoulderAngle(this.getRoboticArm().getShoulderAngle());
            roboticArmData.setTurretAngle(this.getRoboticArm().getTurretAngle());
            roboticArmData.setWristAngle(this.getRoboticArm().getWristAngle());
        }
    }
}

