/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.satellite.tests;

import java.util.Date;
import java.util.Iterator;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.VariableImplementation;
import org.eclipse.apogy.examples.satellite.AbstractConstellationCommandPlan;
import org.eclipse.apogy.examples.satellite.AbstractSatelliteCommand;
import org.eclipse.apogy.examples.satellite.ConstellationState;
import org.eclipse.apogy.examples.satellite.DefaultConstellationPlanner;
import org.eclipse.apogy.examples.satellite.VisibilityPassBasedSatelliteCommand;
import org.eclipse.apogy.examples.satellite.apogy.ConstellationData;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class ApogyExamplesSatelliteTests {
    public static final String SESSION_URI = "platform:/plugin/org.eclipse.apogy.examples.satellite.apogy/sessions/radarsat2.sym";
    public static final String CONTEXT_NAME = "Default";
    public static final String VARIABLE_NAME = "constellation";
    public static final String GENERATED_PLAN_NAME = "Generated";

    public void plan(int numberOfThreads) throws Exception {
        InvocatorSession invocatorSession = (InvocatorSession)EcoreUtil.copy((EObject)ApogyCoreInvocatorFacade.INSTANCE.loadInvocatorSession(SESSION_URI));
        Assert.assertNotNull((Object)invocatorSession);
        ConstellationState constellationState = ApogyExamplesSatelliteTests.getConstellationState(invocatorSession);
        Assert.assertNotNull((Object)constellationState);
        DefaultConstellationPlanner planner = (DefaultConstellationPlanner)constellationState.getConstellationPlannersContainer().getConstellationPlanners().get(0);
        Assert.assertNotNull((Object)planner);
        AbstractConstellationCommandPlan plan = ApogyExamplesSatelliteTests.getSatelliteCommandPlanByName(constellationState, GENERATED_PLAN_NAME);
        AbstractSatelliteCommand command = null;
        VisibilityPassBasedSatelliteCommand visibilityCommand = null;
        planner.setMaxNumberThreads(numberOfThreads);
        planner.plan();
        Assert.assertEquals((long)2L, (long)plan.getSatelliteCommandsList().getConstellationCommands().size());
        command = (AbstractSatelliteCommand)plan.getSatelliteCommandsList().getConstellationCommands().get(0);
        Assert.assertTrue((boolean)(command instanceof VisibilityPassBasedSatelliteCommand));
        visibilityCommand = (VisibilityPassBasedSatelliteCommand)command;
        Assert.assertEquals((Object)new Date(1459405555300L), (Object)visibilityCommand.getTime());
        command = (AbstractSatelliteCommand)plan.getSatelliteCommandsList().getConstellationCommands().get(1);
        Assert.assertTrue((boolean)(command instanceof VisibilityPassBasedSatelliteCommand));
        visibilityCommand = (VisibilityPassBasedSatelliteCommand)command;
        Assert.assertEquals((Object)new Date(1459423814159L), (Object)visibilityCommand.getTime());
    }

    @Test
    public void testDefaultConstellationPlannerMaxCores() throws Exception {
        this.plan(0);
    }

    @Test
    public void testDefaultConstellationPlannerSingleCore() throws Exception {
        this.plan(1);
    }

    public static ConstellationState getConstellationState(InvocatorSession session) {
        Context context = ApogyCoreInvocatorFacade.INSTANCE.getContextByName(session, CONTEXT_NAME);
        VariableImplementation variableImplementation = context.getVariableImplementationsList().getVariableImplementation(VARIABLE_NAME);
        ConstellationData data = (ConstellationData)variableImplementation.getAbstractInitializationData();
        return data.getConstellationState();
    }

    public static AbstractConstellationCommandPlan getSatelliteCommandPlanByName(ConstellationState constellationState, String name) {
        AbstractConstellationCommandPlan constellationCommandPlan = null;
        Iterator plans = constellationState.getConstellationCommandPlansList().getPlans().iterator();
        while (plans.hasNext() && constellationCommandPlan == null) {
            AbstractConstellationCommandPlan plan = (AbstractConstellationCommandPlan)plans.next();
            if (!plan.getName().equals(name)) continue;
            constellationCommandPlan = plan;
        }
        return constellationCommandPlan;
    }
}

