/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.satellite.ui.commands;

import java.util.Iterator;
import org.eclipse.apogy.examples.satellite.AbstractConstellationPlanner;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateConstellationCommandPlan
extends AbstractHandler
implements IHandler {
    private static final Logger Logger = LoggerFactory.getLogger(GenerateConstellationCommandPlan.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Iterator selections = ((IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)).iterator();
        final AbstractConstellationPlanner planner = (AbstractConstellationPlanner)selections.next();
        if (planner != null) {
            try {
                new Job("Constellation Planner"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            planner.plan();
                            EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)planner);
                            if (domain != null) {
                                domain.getCommandStack().execute((Command)IdentityCommand.INSTANCE);
                            }
                        }
                        catch (Exception e) {
                            Logger.error(e.getMessage(), (Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

