/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.satellite;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConstellationRequestStatus implements Enumerator
{
    NEW(0, "NEW", "NEW"),
    COMMITTED(1, "COMMITTED", "COMMITTED"),
    COMPLETED(2, "COMPLETED", "COMPLETED"),
    FAILED(3, "FAILED", "FAILED"),
    ABORTED(4, "ABORTED", "ABORTED");

    public static final int NEW_VALUE = 0;
    public static final int COMMITTED_VALUE = 1;
    public static final int COMPLETED_VALUE = 2;
    public static final int FAILED_VALUE = 3;
    public static final int ABORTED_VALUE = 4;
    private static final ConstellationRequestStatus[] VALUES_ARRAY;
    public static final List<ConstellationRequestStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConstellationRequestStatus[]{NEW, COMMITTED, COMPLETED, FAILED, ABORTED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConstellationRequestStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstellationRequestStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstellationRequestStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstellationRequestStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstellationRequestStatus get(int value) {
        switch (value) {
            case 0: {
                return NEW;
            }
            case 1: {
                return COMMITTED;
            }
            case 2: {
                return COMPLETED;
            }
            case 3: {
                return FAILED;
            }
            case 4: {
                return ABORTED;
            }
        }
        return null;
    }

    private ConstellationRequestStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

