/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.satellite.impl;

import org.eclipse.apogy.core.environment.earth.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.AstronomyUtils;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPass;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPassSpacecraftPosition;
import org.eclipse.apogy.examples.satellite.Satellite;
import org.eclipse.apogy.examples.satellite.impl.DefaultConstellationPlannerImpl;

public class DefaultConstellationPlannerCustomImpl
extends DefaultConstellationPlannerImpl {
    @Override
    public boolean isValid(VisibilityPass visibilityPass) {
        Satellite satellite = this.getSatellite(visibilityPass.getOrbitModel());
        if (satellite == null) {
            return false;
        }
        VisibilityPassSpacecraftPosition closestPosition = visibilityPass.getPositionHistory().getSmallestSpacecraftCrossTrackAnglePosition();
        if (closestPosition == null) {
            return false;
        }
        if (this.isSatelliteRollCommandValid() && Math.abs(closestPosition.getSpacecraftCrossTrackAngle()) > Math.abs(satellite.getMaximumRoll())) {
            return false;
        }
        if (this.isUmbraPassesValid()) {
            double observerLongitude = visibilityPass.getSurfaceLocation().getLongitude();
            double observerLatitude = visibilityPass.getSurfaceLocation().getLatitude();
            HorizontalCoordinates sunCoordinates = AstronomyUtils.INSTANCE.getHorizontalSunPosition(closestPosition.getTime(), observerLongitude, observerLatitude);
            return sunCoordinates.getAltitude() > Math.toRadians(this.getSunHorizonAngleUmbraThreshold());
        }
        return true;
    }
}

