/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.workspace.ui.composites;

import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.workspace.ApogyWorkspaceFacade;
import org.eclipse.apogy.workspace.ui.wizards.ImportProjectWizard;
import org.eclipse.apogy.workspace.ui.wizards.NewProjectWizard;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceProjectsListComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(WorkspaceProjectsListComposite.class);
    private DataBindingContext m_bindingContext;
    private TableViewer viewer;
    private Button btnOpen;
    private Button btnDelete;
    private Button btnImport;
    private Button btnExport;
    private Adapter workspaceAdapter;

    public WorkspaceProjectsListComposite(final Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ApogyWorkspaceFacade.INSTANCE.eAdapters().remove((Object)WorkspaceProjectsListComposite.this.getWorkspaceAdapter());
                if (WorkspaceProjectsListComposite.this.m_bindingContext != null) {
                    WorkspaceProjectsListComposite.this.m_bindingContext.dispose();
                }
            }
        });
        this.viewer = new TableViewer((Composite)this, 2562);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        table.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkspaceProjectsListComposite.this.newSelection(event.getSelection());
            }
        });
        TableViewerColumn tableViewerColumnItem_Name = new TableViewerColumn(this.viewer, 0);
        TableColumn trclmnItemName = tableViewerColumnItem_Name.getColumn();
        trclmnItemName.setWidth(200);
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.btnOpen = new Button(composite, 0);
        this.btnOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    ApogyWorkspaceFacade.INSTANCE.openApogyProject(WorkspaceProjectsListComposite.this.getSelectedProjects().get(0));
                }
                catch (Exception e) {
                    Logger.error("Unable to open project <" + WorkspaceProjectsListComposite.this.getSelectedProjects().get(0).getName() + ">", (Throwable)e);
                }
            }
        });
        this.btnOpen.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnOpen.setText("Open");
        Label label = new Label(composite, 258);
        label.setSize(64, 2);
        Button btnNew = new Button(composite, 0);
        btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new WizardDialog(parent.getShell(), (IWizard)new NewProjectWizard()).open();
            }
        });
        btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        btnNew.setSize(74, 29);
        btnNew.setText("New");
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String projectToDeleteMessage = "";
                Iterator<IProject> projects = WorkspaceProjectsListComposite.this.getSelectedProjects().iterator();
                while (projects.hasNext()) {
                    IProject project = projects.next();
                    projectToDeleteMessage = String.valueOf(projectToDeleteMessage) + project.getName();
                    if (!projects.hasNext()) continue;
                    projectToDeleteMessage = String.valueOf(projectToDeleteMessage) + ", ";
                }
                MessageDialog dialog = new MessageDialog(null, "Delete the selected project", null, "Are you sure to delete these projects: " + projectToDeleteMessage, 3, new String[]{"Yes", "No"}, 1);
                int result = dialog.open();
                if (result == 0) {
                    for (IProject project : WorkspaceProjectsListComposite.this.getSelectedProjects()) {
                        try {
                            ApogyWorkspaceFacade.INSTANCE.deleteApogyProject(project);
                        }
                        catch (Exception e) {
                            Logger.error("Unable to delete the project <" + ApogyWorkspaceFacade.INSTANCE.getActiveProject().getName() + ">", (Throwable)e);
                        }
                    }
                }
            }
        });
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDelete.setSize(74, 29);
        this.btnDelete.setText("Delete");
        Composite composite_1 = new Composite((Composite)this, 0);
        composite_1.setLayout((Layout)new GridLayout(1, false));
        composite_1.setLayoutData((Object)new GridData(4, 1024, false, false, 1, 1));
        this.btnImport = new Button(composite_1, 0);
        this.btnImport.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnImport.setText("Import Session");
        this.btnImport.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent se) {
                try {
                    ImportProjectWizard wizard = new ImportProjectWizard();
                    new WizardDialog(parent.getShell(), (IWizard)wizard).open();
                }
                catch (Exception e) {
                    Logger.error("Unable to import the selected session", (Throwable)e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnExport = new Button(composite_1, 0);
        this.btnExport.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnExport.setSize(74, 29);
        this.btnExport.setText("Export");
        this.btnExport.setEnabled(false);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IProject project = (IProject)element;
                String result = project.getName();
                if (project == ApogyWorkspaceFacade.INSTANCE.getActiveProject()) {
                    result = "<Active> " + result;
                }
                return result;
            }
        });
        this.m_bindingContext = this.customInitDataBindings();
        this.viewer.setInput((Object)ApogyWorkspaceFacade.INSTANCE.getWorkspaceApogyProjects().toArray());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (WorkspaceProjectsListComposite.this.m_bindingContext != null) {
                    WorkspaceProjectsListComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void newSelection(ISelection selection) {
    }

    public List<IProject> getSelectedProjects() {
        return ((IStructuredSelection)this.viewer.getSelection()).toList();
    }

    protected DataBindingContext customInitDataBindings() {
        ApogyWorkspaceFacade.INSTANCE.eAdapters().remove((Object)this.getWorkspaceAdapter());
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.viewer);
        ISWTObservableValue observeEnabledBtnOpenObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnOpen);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnOpenObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        ISWTObservableValue observeEnabledBtnExportObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnExport);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnExportObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(IProject.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        ApogyWorkspaceFacade.INSTANCE.eAdapters().add((Object)this.getWorkspaceAdapter());
        return bindingContext;
    }

    private Adapter getWorkspaceAdapter() {
        if (this.workspaceAdapter == null) {
            this.workspaceAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (!WorkspaceProjectsListComposite.this.isDisposed()) {
                        WorkspaceProjectsListComposite.this.viewer.setInput((Object)ApogyWorkspaceFacade.INSTANCE.getWorkspaceApogyProjects().toArray());
                    }
                }
            };
        }
        return this.workspaceAdapter;
    }
}

