/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mobility.controllers.impl;

import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.mobility.controllers.PathRecorder;
import org.eclipse.apogy.addons.mobility.controllers.PathRecorderSamplingMode;
import org.eclipse.apogy.addons.mobility.controllers.impl.WaypointPathRecorderImpl;
import org.eclipse.apogy.addons.sensors.pose.PoseSensor;
import org.eclipse.apogy.addons.sensors.pose.PositionSensor;
import org.eclipse.apogy.common.ApogyCommonOSGiUtilities;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

public class WaypointPathRecorderCustomImpl
extends WaypointPathRecorderImpl {
    protected Adapter positionAdapter = null;
    protected Adapter positionSensorAdapter = null;
    protected CartesianPositionCoordinates previousPosition = null;
    protected Job sampleOnTimeJob = null;

    protected WaypointPathRecorderCustomImpl() {
        this.initialize();
    }

    private void initialize() {
        this.eAdapters().add((Object)this.getPositionSensorAdapter());
        this.getSampleOnTimeJob().schedule();
    }

    protected Adapter getPositionSensorAdapter() {
        if (this.positionSensorAdapter == null) {
            this.positionSensorAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(PathRecorder.class) == 0) {
                        PoseSensor newPoseSensor;
                        PoseSensor oldPoseSensor = (PoseSensor)msg.getOldValue();
                        if (oldPoseSensor != null) {
                            oldPoseSensor.eAdapters().remove((Object)WaypointPathRecorderCustomImpl.this.getPositionAdapter());
                        }
                        if ((newPoseSensor = (PoseSensor)msg.getNewValue()) != null) {
                            newPoseSensor.eAdapters().add((Object)WaypointPathRecorderCustomImpl.this.getPositionAdapter());
                            if (WaypointPathRecorderCustomImpl.this.getRecordedPath() != null) {
                                ((WayPointPath)WaypointPathRecorderCustomImpl.this.getRecordedPath()).getPoints().clear();
                            }
                            WaypointPathRecorderCustomImpl.this.previousPosition = null;
                        }
                    }
                }
            };
        }
        return this.positionSensorAdapter;
    }

    protected Adapter getPositionAdapter() {
        if (this.positionAdapter == null) {
            this.positionAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    CartesianPositionCoordinates newPoint;
                    if (msg.getFeatureID(PositionSensor.class) == 5 && WaypointPathRecorderCustomImpl.this.isSampleOnDistanceDeltaRequired(newPoint = WaypointPathRecorderCustomImpl.this.getPositionSensor().getPositionCoordinates()) && WaypointPathRecorderCustomImpl.this.getRecordedPath() != null) {
                        ((WayPointPath)WaypointPathRecorderCustomImpl.this.getRecordedPath()).getPoints().add((Object)ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(newPoint));
                    }
                }
            };
        }
        return this.positionAdapter;
    }

    protected boolean isSampleOnDistanceDeltaRequired(CartesianPositionCoordinates newPoint) {
        boolean sampleRequired = false;
        if (this.getSamplingMode() == PathRecorderSamplingMode.ON_DISTANCE_DELTA || this.getSamplingMode() == PathRecorderSamplingMode.ON_TIME_OR_DISTANCE_DELTA) {
            if (this.previousPosition != null) {
                if (newPoint.asPoint3d().distance(this.previousPosition.asPoint3d()) >= this.getMinimumDistanceDelta()) {
                    sampleRequired = true;
                    this.previousPosition = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(newPoint);
                }
            } else {
                sampleRequired = true;
                this.previousPosition = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(newPoint);
            }
        }
        return sampleRequired;
    }

    protected boolean isSampleOnTimeDeltaRequired() {
        return this.getSamplingMode() == PathRecorderSamplingMode.ON_TIME_DELTA | this.getSamplingMode() == PathRecorderSamplingMode.ON_TIME_OR_DISTANCE_DELTA;
    }

    private Job getSampleOnTimeJob() {
        if (this.sampleOnTimeJob == null) {
            this.sampleOnTimeJob = new Job("WaypointPathRecorder Update On Time"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (WaypointPathRecorderCustomImpl.this.isSampleOnTimeDeltaRequired() && WaypointPathRecorderCustomImpl.this.getRecordedPath() != null) {
                        ((WayPointPath)WaypointPathRecorderCustomImpl.this.getRecordedPath()).getPoints().add((Object)ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(WaypointPathRecorderCustomImpl.this.getPositionSensor().getPositionCoordinates()));
                    }
                    long delay = Math.round(WaypointPathRecorderCustomImpl.this.getMinimumTimeDelta() * 1000.0);
                    this.schedule(delay);
                    return new Status(0, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(WaypointPathRecorderCustomImpl.this.getClass()), 0, null, null);
                }
            };
        }
        return this.sampleOnTimeJob;
    }
}

