/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mobility.pathplanners.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Cylinder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.addons.mobility.pathplanners.CircularExclusionZone;
import org.eclipse.apogy.addons.mobility.pathplanners.ui.scene_objects.CircularExclusionZoneSceneObject;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircularExclusionZoneJME3Object
extends DefaultJME3SceneObject<CircularExclusionZone>
implements CircularExclusionZoneSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(CircularExclusionZoneJME3Object.class);
    private Adapter adapter;
    private float radius = 1.0f;
    private float height = 1.0f;
    private AssetManager assetManager;
    private MeshPresentationMode meshPresentationMode = MeshPresentationMode.WIREFRAME;
    private Geometry geometry;
    private ColorRGBA circularExclusionZoneColorRBGA = ColorRGBA.Red;

    public CircularExclusionZoneJME3Object(CircularExclusionZone node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)node, jme3RenderEngineDelegate);
        if (node == null || jme3RenderEngineDelegate == null) {
            throw new IllegalArgumentException();
        }
        this.assetManager = this.jme3Application.getAssetManager();
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                CircularExclusionZoneJME3Object.this.radius = (float)((CircularExclusionZone)CircularExclusionZoneJME3Object.this.getTopologyNode()).getRadius();
                CircularExclusionZoneJME3Object.this.createGeometry();
                return null;
            }
        });
        ((CircularExclusionZone)this.getTopologyNode()).eAdapters().add((Object)this.getAdapter());
    }

    public void updateGeometry(float tpf) {
        if (this.geometry != null) {
            this.getAttachmentNode().detachChild((Spatial)this.geometry);
        }
        this.geometry = this.createCylinderGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.geometry);
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((CircularExclusionZone)this.getTopologyNode()).eAdapters().remove((Object)this.getAdapter());
        }
        super.dispose();
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.geometry);
        return geometries;
    }

    public void setColor(final RGB rgb) {
        this.circularExclusionZoneColorRBGA = JME3Utilities.convertToColorRGBA((RGB)rgb);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    if (CircularExclusionZoneJME3Object.this.geometry != null) {
                        Material mat = CircularExclusionZoneJME3Object.this.createMaterial();
                        CircularExclusionZoneJME3Object.this.geometry.setMaterial(mat);
                    }
                }
                catch (Throwable t) {
                    Logger.error("Failed to set color to <" + rgb + ">.", t);
                }
                return null;
            }
        });
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.requestUpdate();
    }

    public float getRadius() {
        return this.radius;
    }

    public void setHeight(double height) {
        this.height = (float)height;
        this.requestUpdate();
    }

    public double getHeight() {
        return this.height;
    }

    public MeshPresentationMode getPresentationMode() {
        return this.meshPresentationMode;
    }

    public void setPresentationMode(final MeshPresentationMode presentationMode) {
        this.meshPresentationMode = presentationMode;
        if (this.geometry != null && this.geometry.getMaterial() != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    switch (presentationMode.getValue()) {
                        case 1: {
                            CircularExclusionZoneJME3Object.this.geometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                            if (CircularExclusionZoneJME3Object.this.geometry.getMesh() == null) break;
                            CircularExclusionZoneJME3Object.this.geometry.getMesh().setMode(Mesh.Mode.Triangles);
                            break;
                        }
                        case 2: {
                            CircularExclusionZoneJME3Object.this.geometry.getMaterial().getAdditionalRenderState().setWireframe(true);
                            if (CircularExclusionZoneJME3Object.this.geometry.getMesh() == null) break;
                            CircularExclusionZoneJME3Object.this.geometry.getMesh().setMode(Mesh.Mode.Lines);
                            break;
                        }
                        case 0: {
                            CircularExclusionZoneJME3Object.this.geometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                            if (CircularExclusionZoneJME3Object.this.geometry.getMesh() == null) break;
                            CircularExclusionZoneJME3Object.this.geometry.getMesh().setMode(Mesh.Mode.Points);
                            break;
                        }
                    }
                    return null;
                }
            });
        }
    }

    private void createGeometry() {
        this.geometry = this.createCylinderGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.geometry);
    }

    private Geometry createCylinderGeometry() {
        Mesh mesh = this.createMesh();
        Geometry geometry = new Geometry("Exclusion Zone", mesh);
        geometry.setMaterial(this.createMaterial());
        return geometry;
    }

    private Mesh createMesh() {
        Cylinder cylinder = new Cylinder(4, 10, this.radius, this.height, false);
        return cylinder;
    }

    private Material createMaterial() {
        Material mat = null;
        mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        if (this.circularExclusionZoneColorRBGA != null) {
            mat.setColor("Diffuse", this.circularExclusionZoneColorRBGA);
            mat.setColor("Ambient", this.circularExclusionZoneColorRBGA);
            mat.setColor("Specular", this.circularExclusionZoneColorRBGA);
        }
        mat.setFloat("Shininess", 64.0f);
        mat.setBoolean("UseMaterialColors", true);
        return mat;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (notification.getNotifier() instanceof CircularExclusionZone) {
                        int featureId = notification.getFeatureID(CircularExclusionZone.class);
                        switch (featureId) {
                            case 3: {
                                CircularExclusionZoneJME3Object.this.setRadius((float)notification.getNewDoubleValue());
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

