/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.composites;

import org.eclipse.apogy.addons.sensors.imaging.AbstractCamera;
import org.eclipse.apogy.addons.sensors.imaging.ImageSnapshot;
import org.eclipse.apogy.addons.sensors.imaging.camera.DrawnCameraOverlay;
import org.eclipse.apogy.addons.sensors.imaging.camera.internal.AbstractCameraStub;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.ui.composites.ImageDisplayComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrawnCameraOverlayPreviewComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(DrawnCameraOverlayPreviewComposite.class);
    private DrawnCameraOverlay drawnCameraOverlay;
    private Adapter drawnCameraOverlayAdapter;
    private final AbstractCameraStub abstractCameraStub = new AbstractCameraStub("platform:/plugin/org.eclipse.apogy.addons.sensors.imaging.camera/images/unfiltered_image.jpg", Math.toRadians(45.0), Math.toRadians(25.3125));
    private final ImageDisplayComposite imagePreviewComposite;

    public DrawnCameraOverlayPreviewComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.imagePreviewComposite = new ImageDisplayComposite((Composite)this, 0);
    }

    public DrawnCameraOverlay getDrawnCameraOverlay() {
        return this.drawnCameraOverlay;
    }

    public void setDrawnCameraOverlay(DrawnCameraOverlay drawnCameraOverlay) {
        if (this.drawnCameraOverlay != null) {
            this.drawnCameraOverlay.eAdapters().remove((Object)this.getDrawnCameraOverlayAdapter());
        }
        this.drawnCameraOverlay = drawnCameraOverlay;
        if (this.drawnCameraOverlay != null) {
            this.drawnCameraOverlay.eAdapters().add((Object)this.getDrawnCameraOverlayAdapter());
            this.updatePreview();
        }
    }

    protected void updatePreview() {
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (DrawnCameraOverlayPreviewComposite.this.getDrawnCameraOverlay() != null) {
                            DrawnCameraOverlayPreviewComposite.this.abstractCameraStub.setName("Test Camera");
                            DrawnCameraOverlayPreviewComposite.this.abstractCameraStub.setDescription("A test camera.");
                            ImageSnapshot imageSnapshot = DrawnCameraOverlayPreviewComposite.this.abstractCameraStub.takeSnapshot();
                            AbstractEImage abstractEImage = imageSnapshot.getImage();
                            AbstractEImage resultImage = DrawnCameraOverlayPreviewComposite.this.getDrawnCameraOverlay().applyOverlay((AbstractCamera)DrawnCameraOverlayPreviewComposite.this.abstractCameraStub, abstractEImage, DrawnCameraOverlayPreviewComposite.this.getDrawnCameraOverlay().getOverlayAlignment(), abstractEImage.getWidth(), abstractEImage.getHeight());
                            ImageData imageData = EImagesUtilities.INSTANCE.convertToImageData(resultImage.asBufferedImage());
                            if (DrawnCameraOverlayPreviewComposite.this.imagePreviewComposite != null && !DrawnCameraOverlayPreviewComposite.this.imagePreviewComposite.isDisposed() && imageData != null) {
                                DrawnCameraOverlayPreviewComposite.this.imagePreviewComposite.setImageData(imageData);
                                DrawnCameraOverlayPreviewComposite.this.imagePreviewComposite.fitImage();
                            }
                        }
                    }
                    catch (Exception e) {
                        Logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    private Adapter getDrawnCameraOverlayAdapter() {
        if (this.drawnCameraOverlayAdapter == null) {
            this.drawnCameraOverlayAdapter = new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    DrawnCameraOverlayPreviewComposite.this.updatePreview();
                    super.notifyChanged(notification);
                }
            };
        }
        return this.drawnCameraOverlayAdapter;
    }
}

