/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.vecmath.Color3f;
import org.eclipse.apogy.addons.sensors.imaging.AbstractCamera;
import org.eclipse.apogy.addons.sensors.imaging.camera.OverlayAlignment;
import org.eclipse.apogy.addons.sensors.imaging.camera.impl.AbstractTextOverlayImpl;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTextOverlayCustomImpl
extends AbstractTextOverlayImpl {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractTextOverlayImpl.class);

    @Override
    public AbstractEImage applyOverlay(AbstractCamera camera, AbstractEImage cameraImage, OverlayAlignment overlayAlignment, int overlayWidth, int overlayHeight) {
        String text = this.getDisplayedString();
        if (text != null && text.length() > 0) {
            EImage result = ApogyCommonImagesFactory.eINSTANCE.createEImage();
            result.setImageContent(cameraImage.asBufferedImage());
            BufferedImage image = result.asBufferedImage();
            Graphics2D g2d = image.createGraphics();
            g2d.setColor(this.getColorOfText());
            Font font = this.getFont(this.getFontName(), 1, this.getFontSize());
            g2d.setFont(font);
            FontMetrics fontMetrics = g2d.getFontMetrics(font);
            Rectangle2D textArea = fontMetrics.getStringBounds(text, g2d);
            int x = 0;
            int y = 0;
            switch (overlayAlignment.getValue()) {
                case 1: {
                    x = (int)Math.floor(((double)overlayWidth - textArea.getWidth()) * 0.5);
                    y = (int)Math.floor(((double)overlayHeight - textArea.getHeight()) * 0.5);
                    break;
                }
                case 2: {
                    x = this.getHorizontalOffset();
                    y = overlayHeight - this.getVerticalOffset();
                    break;
                }
                case 4: {
                    x = overlayWidth - this.getHorizontalOffset() - (int)Math.round(textArea.getWidth());
                    y = overlayHeight - this.getVerticalOffset();
                    break;
                }
                case 3: {
                    x = this.getHorizontalOffset();
                    y = this.getVerticalOffset() + (int)Math.round(textArea.getHeight());
                    break;
                }
                case 5: {
                    x = overlayWidth - this.getHorizontalOffset() - (int)Math.round(textArea.getWidth());
                    y = this.getVerticalOffset() + (int)Math.round(textArea.getHeight());
                    break;
                }
            }
            Color textBackGroundColor = this.getTextBackgroundColor();
            if (textBackGroundColor != null) {
                int boxWidth = (int)Math.round(textArea.getWidth());
                int boxHeight = (int)Math.round(textArea.getHeight());
                LineMetrics l = fontMetrics.getLineMetrics(text, g2d);
                int boxY = Math.round((float)(y - boxHeight) + l.getDescent());
                g2d.setColor(textBackGroundColor);
                g2d.fillRect(x, boxY, boxWidth, boxHeight);
            }
            g2d.setColor(this.getColorOfText());
            g2d.drawString(text, x, y);
            g2d.dispose();
            result.setImageContent(image);
            return result;
        }
        return cameraImage;
    }

    protected Font getFont(String fontName, int style, int size) {
        Font font = null;
        try {
            font = new Font(fontName, style, size);
        }
        catch (Throwable t) {
            Logger.error("Failed to create font < name : " + fontName + ", style : " + style + ", size" + size + ">.", t);
            font = new Font("Serif", 0, size);
        }
        return font;
    }

    protected Color getColorOfText() {
        Color3f color3f = this.getTextColor();
        if (color3f != null && color3f.getX() >= 0.0f && color3f.getY() >= 0.0f && color3f.getZ() >= 0.0f) {
            return new Color(this.getTextColor().getX(), this.getTextColor().getY(), this.getTextColor().getZ());
        }
        return Color.GREEN;
    }

    protected Color getTextBackgroundColor() {
        return null;
    }
}

