/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.impl;

import java.awt.Graphics2D;
import java.awt.Image;
import org.eclipse.apogy.addons.sensors.imaging.AbstractCamera;
import org.eclipse.apogy.addons.sensors.imaging.camera.OverlayAlignment;
import org.eclipse.apogy.addons.sensors.imaging.camera.impl.ApogyLogoOverlayImpl;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.URLEImage;

public class ApogyLogoOverlayCustomImpl
extends ApogyLogoOverlayImpl {
    private AbstractEImage logoImage = null;

    @Override
    public AbstractEImage getOverlay(AbstractCamera camera, OverlayAlignment overlayAlignment, int overlayWidth, int overlayHeight) {
        AbstractEImage image = EImagesUtilities.INSTANCE.createTransparentImage(overlayWidth, overlayHeight);
        double widthScaleFactor = (double)overlayWidth / (4.0 * (double)this.getLogoImage().getWidth());
        double heightScaleFactor = (double)overlayHeight / (4.0 * (double)this.getLogoImage().getHeight());
        double scaleFactor = 1.0;
        scaleFactor = widthScaleFactor < heightScaleFactor ? widthScaleFactor : heightScaleFactor;
        AbstractEImage resizedLogo = EImagesUtilities.INSTANCE.resize(this.getLogoImage(), scaleFactor);
        int x = 0;
        int y = 0;
        switch (overlayAlignment.getValue()) {
            case 1: {
                x = (int)Math.floor((double)(overlayWidth - resizedLogo.getWidth()) * 0.5);
                y = (int)Math.floor((double)(overlayHeight - resizedLogo.getHeight()) * 0.5);
                break;
            }
            case 2: {
                x = 0;
                y = overlayHeight - resizedLogo.getHeight();
                break;
            }
            case 4: {
                x = overlayWidth - Math.round(resizedLogo.getWidth());
                y = overlayHeight - Math.round(resizedLogo.getHeight());
                break;
            }
            case 3: {
                x = 0;
                y = 0;
                break;
            }
            case 5: {
                x = overlayWidth - Math.round(resizedLogo.getWidth());
                y = 0;
                break;
            }
        }
        Graphics2D g2d = image.asBufferedImage().createGraphics();
        g2d.drawImage((Image)resizedLogo.asBufferedImage(), x, y, null);
        g2d.dispose();
        return image;
    }

    protected AbstractEImage getLogoImage() {
        if (this.logoImage == null) {
            URLEImage urlImage = ApogyCommonImagesFactory.eINSTANCE.createURLEImage();
            urlImage.setUrl("platform:/plugin/org.eclipse.apogy.addons.sensors.imaging.camera/images/ApogyLogo.gif");
            this.logoImage = urlImage;
        }
        return this.logoImage;
    }
}

