/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.wizards;

import org.eclipse.apogy.addons.sensors.imaging.camera.FOVOverlay;
import org.eclipse.apogy.addons.sensors.imaging.camera.composites.FOVOverlayComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class FOVOverlayWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.addons.sensors.imaging.camera.wizards.FOVOverlayWizardPage";
    private final FOVOverlay fovOverlay;
    private FOVOverlayComposite fovOverlayComposite;
    private DataBindingContext m_bindingContext;

    public FOVOverlayWizardPage(FOVOverlay fovOverlay) {
        super(WIZARD_PAGE_ID);
        this.fovOverlay = fovOverlay;
        this.setTitle("Filed Of View (FOV) Overlay.");
        this.setDescription("Select the FOV settings.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.fovOverlayComposite = new FOVOverlayComposite(top, 2048){

            @Override
            protected void lineWidthSelected(int lineWidth) {
                FOVOverlayWizardPage.this.validate();
            }

            @Override
            protected void angleIntervalSelected(int angleInterval) {
                FOVOverlayWizardPage.this.validate();
            }
        };
        this.fovOverlayComposite.setFovOverlay(this.fovOverlay);
        this.fovOverlayComposite.setLayoutData(new GridData(4, 4, true, true));
        this.setControl((Control)top);
        this.m_bindingContext = this.initDataBindingsCustom();
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FOVOverlayWizardPage.this.m_bindingContext != null) {
                    FOVOverlayWizardPage.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.fovOverlay.getFontName() == null) {
            this.setErrorMessage("No font selected !");
        }
        if (this.fovOverlay.getAngleInterval() <= 0) {
            this.setErrorMessage("Invalid Angle Interval specified ! Must be greater than zero.");
        }
        if (this.fovOverlay.getLineWidth() <= 0) {
            this.setErrorMessage("Invalid Line Width specified ! Must be greater than zero.");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

