/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.wizards;

import org.eclipse.apogy.addons.sensors.imaging.camera.RescaleFilter;
import org.eclipse.apogy.addons.sensors.imaging.camera.composites.RescaleFilterComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RescaleFilterWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.addons.sensors.imaging.camera.wizards.RescaleFilterWizardPage";
    private final RescaleFilter rescaleFilter;
    private RescaleFilterComposite rescaleFilterComposite;
    private DataBindingContext m_bindingContext;

    public RescaleFilterWizardPage(RescaleFilter rescaleFilter) {
        super(WIZARD_PAGE_ID);
        this.rescaleFilter = rescaleFilter;
        this.setTitle("Rescale Filter.");
        this.setDescription("Select filter settings.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.rescaleFilterComposite = new RescaleFilterComposite(top, 0){

            @Override
            protected void newExposureSelected(double exposure) {
                RescaleFilterWizardPage.this.validate();
            }
        };
        this.rescaleFilterComposite.setLayoutData(new GridData(4, 4, true, true));
        this.rescaleFilterComposite.setRescaleFilter(this.rescaleFilter);
        this.setControl((Control)top);
        this.m_bindingContext = this.initDataBindingsCustom();
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (RescaleFilterWizardPage.this.m_bindingContext != null) {
                    RescaleFilterWizardPage.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.rescaleFilter.getScale() < 0.0) {
            this.setErrorMessage("Invalid scale specified ! Must be equal or greater than zero.");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

