/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.pose.ui.dialogs;

import org.eclipse.apogy.addons.sensors.pose.OrientationSensor;
import org.eclipse.apogy.addons.sensors.pose.ui.composites.EditOrientationComposite;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetOrientationDialog
extends MessageDialog {
    private static final Logger Logger = LoggerFactory.getLogger(ResetOrientationDialog.class);
    private OrientationSensor orientationSensor;
    private EditOrientationComposite editOrientationComposite;
    private static final int APPLY_BUTTON_ID = 0;
    private static final int CLOSE_BUTTON_ID = 1;

    public ResetOrientationDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    public ResetOrientationDialog(Shell parentShell, OrientationSensor orientationSensor) {
        super(parentShell, "Reset Orientation", null, null, 0, new String[]{"Apply", "Close"}, 0);
        this.orientationSensor = orientationSensor;
    }

    protected Control createCustomArea(Composite parent) {
        this.editOrientationComposite = new EditOrientationComposite(parent, 0, this.orientationSensor);
        return this.editOrientationComposite;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                try {
                    this.orientationSensor.resetOrientation(this.editOrientationComposite.getNewValues());
                }
                catch (Exception e) {
                    Logger.error("Error occured while reseting orientation.");
                }
                break;
            }
            case 1: {
                this.close();
                break;
            }
            default: {
                this.close();
            }
        }
    }
}

