/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.pose.ui.dialogs;

import org.eclipse.apogy.addons.sensors.pose.PositionSensor;
import org.eclipse.apogy.addons.sensors.pose.ui.composites.EditPositionComposite;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetPositionDialog
extends MessageDialog {
    private static final Logger Logger = LoggerFactory.getLogger(ResetPositionDialog.class);
    private PositionSensor positionSensor;
    private EditPositionComposite editPositionNodePositionComposite;
    private static final int APPLY_BUTTON_ID = 0;
    private static final int CLOSE_BUTTON_ID = 1;

    public ResetPositionDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    public ResetPositionDialog(Shell parentShell, PositionSensor positionSensor) {
        super(parentShell, "Reset Position", null, null, 0, new String[]{"Apply", "Close"}, 0);
        this.positionSensor = positionSensor;
    }

    protected Control createCustomArea(Composite parent) {
        this.editPositionNodePositionComposite = new EditPositionComposite(parent, 0, this.positionSensor);
        return this.editPositionNodePositionComposite;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                try {
                    this.positionSensor.resetPosition(this.editPositionNodePositionComposite.getNewValues());
                }
                catch (Exception e) {
                    Logger.error("Error occured while reseting position.", (Throwable)e);
                }
                break;
            }
            case 1: {
                this.close();
                break;
            }
            default: {
                this.close();
            }
        }
    }
}

