/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.composites;

import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EOperationsComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(EOperationsComposite.class);
    private DataBindingContext m_bindingContext;
    private EClass eClass;
    private final Tree tree;
    private final TreeViewer treeViewer;
    private ISelectionChangedListener treeViewerSelectionChangedListener;
    private boolean parametersVisible = false;
    private EOperation defaultSelectedEOperation;
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());

    public EOperationsComposite(Composite parent, int style) {
        super(parent, 0);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EOperationsComposite.this.m_bindingContext != null) {
                    EOperationsComposite.this.m_bindingContext.dispose();
                    EOperationsComposite.this.m_bindingContext = null;
                }
                EOperationsComposite.this.toolkit.dispose();
                EOperationsComposite.this.treeViewer.removeSelectionChangedListener(EOperationsComposite.this.getTreeViewerSelectionChangedListener());
            }
        });
        this.setLayout((Layout)new FillLayout());
        this.treeViewer = new TreeViewer((Composite)this, 2048);
        this.tree = this.treeViewer.getTree();
        this.tree.setLinesVisible(true);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.treeViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EOperationsComposite.this.m_bindingContext != null) {
                    EOperationsComposite.this.m_bindingContext.dispose();
                    EOperationsComposite.this.m_bindingContext = null;
                }
                EOperationsComposite.this.toolkit.dispose();
                EOperationsComposite.this.treeViewer.removeSelectionChangedListener(EOperationsComposite.this.getTreeViewerSelectionChangedListener());
            }
        });
    }

    public void showParameters(boolean visible) {
        this.parametersVisible = visible;
    }

    private ISelectionChangedListener getTreeViewerSelectionChangedListener() {
        if (this.treeViewerSelectionChangedListener == null) {
            this.treeViewerSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    EOperationsComposite.this.newSelection((TreeSelection)event.getSelection());
                }
            };
        }
        return this.treeViewerSelectionChangedListener;
    }

    protected void newSelection(TreeSelection selection) {
    }

    public EOperation getSelectedEOperation() {
        return (EOperation)((TreeSelection)this.treeViewer.getSelection()).getFirstElement();
    }

    public EClass getEClass() {
        return this.eClass;
    }

    public void setEClass(EClass newEClass) {
        this.setEClass(newEClass, null);
    }

    public void setEClass(EClass newEClass, EOperation defaultEOperation) {
        this.treeViewer.removeSelectionChangedListener(this.getTreeViewerSelectionChangedListener());
        this.eClass = newEClass;
        this.defaultSelectedEOperation = defaultEOperation;
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
            this.m_bindingContext = null;
        }
        this.m_bindingContext = this.initDataBindings();
        this.treeViewer.addSelectionChangedListener(this.getTreeViewerSelectionChangedListener());
    }

    protected DataBindingContext initDataBindings() {
        return this.initDataBindingsCustom();
    }

    protected DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        this.treeViewer.setInput((Object)this.getEClass());
        if (this.defaultSelectedEOperation != null) {
            try {
                TreeSelection treeSelection = new TreeSelection(new TreePath((Object[])new EOperation[]{this.defaultSelectedEOperation}));
                this.treeViewer.setSelection((ISelection)treeSelection, true);
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
        return bindingContext;
    }

    private ITreeContentProvider getContentProvider() {
        ITreeContentProvider provider = new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof EClass) {
                    EClass eclass = (EClass)inputElement;
                    ArrayList eOperations = new ArrayList();
                    eOperations.addAll(eclass.getEOperations());
                    EList superClasses = eclass.getEAllSuperTypes();
                    for (EClass superEClass : superClasses) {
                        eOperations.addAll(superEClass.getEOperations());
                    }
                    return eOperations.toArray();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof EClass) {
                    EClass eclass = (EClass)parentElement;
                    ArrayList eOperations = new ArrayList();
                    eOperations.addAll(eclass.getEOperations());
                    EList superClasses = eclass.getEAllSuperTypes();
                    for (EClass superEClass : superClasses) {
                        eOperations.addAll(superEClass.getEOperations());
                    }
                    return eOperations.toArray();
                }
                if (EOperationsComposite.this.parametersVisible && parentElement instanceof EOperation) {
                    EOperation eOperation = (EOperation)parentElement;
                    return eOperation.getEParameters().toArray();
                }
                return null;
            }

            public Object getParent(Object element) {
                if (element instanceof EClass) {
                    return null;
                }
                if (element instanceof EOperation) {
                    EOperation eOperation = (EOperation)element;
                    return eOperation.eContainer();
                }
                if (element instanceof EParameter) {
                    EParameter eParameter = (EParameter)element;
                    return eParameter.eContainer();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof EClass) {
                    EClass eClass = (EClass)element;
                    return eClass.getEOperations().size() > 0;
                }
                if (EOperationsComposite.this.parametersVisible && element instanceof EOperation) {
                    EOperation eOperation = (EOperation)element;
                    return eOperation.getEParameters().size() > 0;
                }
                return false;
            }
        };
        return provider;
    }
}

