/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.composites;

import java.text.DecimalFormat;
import javax.measure.converter.ConversionException;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.Ranges;
import org.eclipse.apogy.common.emf.ui.Activator;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.FormatProvider;
import org.eclipse.apogy.common.emf.ui.SimpleFormatProvider;
import org.eclipse.apogy.common.emf.ui.SimpleUnitsProvider;
import org.eclipse.apogy.common.emf.ui.UnitsProvider;
import org.eclipse.apogy.common.emf.ui.dialogs.SelectUnitDialog;
import org.eclipse.apogy.common.emf.ui.preferences.PreferencesConstants;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedElementSimpleUnitsComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(TypedElementSimpleUnitsComposite.class);
    private DataBindingContext bindingContext;
    private Binding valueBinding;
    private Binding colorBinding;
    private IPropertyChangeListener propertyChangeListener;
    private EObject eObject;
    private FeaturePath featurePath;
    private String noValueText = "";
    private int labelWidth = -1;
    private Label nameLabel;
    private final Text valueText;
    private Button unitsButton;
    private Label unitsLabel;

    public TypedElementSimpleUnitsComposite(Composite parent, int style) {
        this(parent, style, true, true, "");
    }

    public TypedElementSimpleUnitsComposite(Composite parent, int style, boolean showLabel, boolean showUnitsButton, boolean showUnits, String noValueText) {
        this(parent, style, showLabel, showUnitsButton, showUnits, noValueText, -1, -1, -1);
    }

    public TypedElementSimpleUnitsComposite(Composite parent, int style, boolean showLabel, boolean showUnitsButton, String noValueText) {
        this(parent, style, showLabel, showUnitsButton, false, noValueText);
    }

    public TypedElementSimpleUnitsComposite(Composite parent, int style, boolean showLabel, boolean showUnitsButton, boolean showUnits, String noValueText, int labelWidth, int valueWidth, int buttonUnitsWidth) {
        super(parent, style);
        this.noValueText = noValueText;
        this.labelWidth = labelWidth;
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPropertyChangeListener());
        int gridSize = 1;
        if (showLabel) {
            ++gridSize;
        }
        if (showUnitsButton || showUnits) {
            ++gridSize;
        }
        GridLayout layout = new GridLayout(gridSize, false);
        layout.marginHeight = 0;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        this.setLayout((Layout)layout);
        if (showLabel) {
            this.nameLabel = this.createFeatureLabel(this, this.labelWidth);
        }
        this.valueText = this.getValueText(this, valueWidth);
        this.valueText.setText(this.getNoValueText());
        this.valueText.setEditable(this.isFeatureEditable());
        if (showUnitsButton) {
            this.unitsButton = this.createUnitsButton(this, buttonUnitsWidth);
            this.unitsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectUnitDialog dialog = new SelectUnitDialog(TypedElementSimpleUnitsComposite.this.getShell(), TypedElementSimpleUnitsComposite.this.resolveValue(TypedElementSimpleUnitsComposite.this.eObject, TypedElementSimpleUnitsComposite.this.featurePath), TypedElementSimpleUnitsComposite.this.getDecimalFormat(), TypedElementSimpleUnitsComposite.this.getNativeUnits(), TypedElementSimpleUnitsComposite.this.getDisplayUnits()){

                        protected void buttonPressed(int buttonId) {
                            if (buttonId == 0) {
                                try {
                                    if (TypedElementSimpleUnitsComposite.this.getDecimalFormat() != this.getResultFormat()) {
                                        SimpleFormatProvider formatProvider = ApogyCommonEMFUIFactory.eINSTANCE.createSimpleFormatProvider();
                                        formatProvider.setFormatPattern(this.getResultFormat().toPattern());
                                        ApogyCommonEMFUIFacade.INSTANCE.addFormatProviderToRegistry((ETypedElement)TypedElementSimpleUnitsComposite.this.getEStructuralFeature(), (FormatProvider)formatProvider);
                                    }
                                    if (TypedElementSimpleUnitsComposite.this.getDisplayUnits() != this.getResultUnit()) {
                                        SimpleUnitsProvider unitsProvider = ApogyCommonEMFUIFactory.eINSTANCE.createSimpleUnitsProvider();
                                        unitsProvider.setUnit(this.getResultUnit());
                                        ApogyCommonEMFUIFacade.INSTANCE.addUnitsProviderToRegistry((ETypedElement)TypedElementSimpleUnitsComposite.this.getEStructuralFeature(), (UnitsProvider)unitsProvider);
                                    }
                                }
                                catch (ConversionException e) {
                                    Logger.error("The value can not be converted ");
                                }
                            }
                            super.buttonPressed(buttonId);
                        }
                    };
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        TypedElementSimpleUnitsComposite.this.updateButton();
                        TypedElementSimpleUnitsComposite.this.updateValueTooltip();
                        TypedElementSimpleUnitsComposite.this.updateUnitsLabel();
                        TypedElementSimpleUnitsComposite.this.valueBinding.updateModelToTarget();
                    }
                }
            });
        } else if (showUnits) {
            this.unitsLabel = this.createUnitsLabel(this, buttonUnitsWidth);
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TypedElementSimpleUnitsComposite.this.propertyChangeListener != null) {
                    Activator.getDefault().getPreferenceStore().removePropertyChangeListener(TypedElementSimpleUnitsComposite.this.getPropertyChangeListener());
                }
            }
        });
    }

    public void setTypedElement(EStructuralFeature eStructuralFeature, EObject instance) {
        if (this.bindingContext != null) {
            this.bindingContext.dispose();
        }
        this.eObject = instance;
        this.featurePath = eStructuralFeature != null ? FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{eStructuralFeature}) : null;
        if (this.nameLabel != null && "".equals(this.getLabelText())) {
            this.nameLabel.setText(String.valueOf(this.getLabelFromEStructuralFeature(this.getEStructuralFeature())) + " :");
        }
        if (instance != null && eStructuralFeature != null) {
            this.initDataBindingsCustom();
            this.updateButton();
            this.updateUnitsLabel();
            this.updateValueTooltip();
        }
        this.layout();
    }

    public void setTypedElement(FeaturePath featurePath, EObject instance) {
        if (this.bindingContext != null) {
            this.bindingContext.dispose();
        }
        this.eObject = instance;
        this.featurePath = featurePath;
        if (this.nameLabel != null && "".equals(this.getLabelText())) {
            this.nameLabel.setText(String.valueOf(this.getLabelFromEStructuralFeature(this.getEStructuralFeature())) + " : ");
        }
        if (instance != null && this.getEStructuralFeature() != null) {
            this.initDataBindingsCustom();
            this.updateButton();
            this.updateUnitsLabel();
            this.updateValueTooltip();
        }
        this.layout();
    }

    public void setInstance(EObject instance) {
        this.eObject = instance;
        if (instance != null && this.getEStructuralFeature() != null) {
            this.initDataBindingsCustom();
            this.updateButton();
            this.updateUnitsLabel();
            this.updateValueTooltip();
        }
        this.layout();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.valueText != null && !this.valueText.isDisposed()) {
            this.valueText.setEnabled(enabled);
        }
        if (this.unitsButton != null && !this.unitsButton.isDisposed()) {
            this.unitsButton.setEnabled(enabled);
        }
    }

    protected String getNoValueText() {
        if (this.noValueText == null) {
            return "";
        }
        return this.noValueText;
    }

    protected Label createFeatureLabel(Composite parent, int labelWidth) {
        Label lblFeatureName = new Label(parent, 0);
        lblFeatureName.setAlignment(131072);
        if (labelWidth > 0) {
            GridData gridData = new GridData(131072, 0x1000000, false, false, 1, 1);
            gridData.minimumWidth = labelWidth;
            gridData.widthHint = labelWidth;
            lblFeatureName.setLayoutData((Object)gridData);
        } else {
            lblFeatureName.setLayoutData((Object)new GridData(4, 0x1000000, false, true, 1, 1));
        }
        lblFeatureName.setText(this.getLabelText());
        return lblFeatureName;
    }

    protected Text getValueText(Composite parent, int valueWidth) {
        Text txtValue = new Text((Composite)this, 133120);
        if (valueWidth > 0) {
            GridData gridData = new GridData(16384, 0x1000000, false, false, 1, 1);
            gridData.minimumWidth = valueWidth;
            gridData.widthHint = valueWidth;
            txtValue.setLayoutData((Object)gridData);
        } else {
            txtValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }
        return txtValue;
    }

    protected Label createUnitsLabel(Composite parent, int buttonUnitsWidth) {
        Label lblUnits = new Label(parent, 0);
        if (buttonUnitsWidth > 0) {
            GridData gd_unitsLabel = new GridData(16384, 0x1000000, false, true, 1, 1);
            gd_unitsLabel.minimumWidth = buttonUnitsWidth;
            gd_unitsLabel.widthHint = buttonUnitsWidth;
            lblUnits.setLayoutData((Object)gd_unitsLabel);
        } else {
            lblUnits.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }
        lblUnits.setText("Units");
        return lblUnits;
    }

    protected Button createUnitsButton(Composite parent, int buttonUnitsWidth) {
        Button btnUnits = new Button(parent, 8);
        btnUnits.setText("Units");
        if (buttonUnitsWidth > 0) {
            GridData gridData = new GridData(16384, 0x1000000, true, false, 1, 1);
            gridData.minimumWidth = buttonUnitsWidth;
            gridData.widthHint = buttonUnitsWidth;
            btnUnits.setLayoutData((Object)gridData);
        } else {
            btnUnits.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }
        return btnUnits;
    }

    protected String getLabelText() {
        return "";
    }

    protected EStructuralFeature getEStructuralFeature() {
        EStructuralFeature[] features;
        EStructuralFeature feature = null;
        if (this.featurePath != null && (features = this.featurePath.getFeaturePath()) != null && features.length > 0) {
            feature = features[features.length - 1];
        }
        return feature;
    }

    protected String getLabelFromEStructuralFeature(EStructuralFeature eStructuralFeature) {
        String raw = this.getEStructuralFeature().getName();
        String formated = raw.replaceAll("(.)([A-Z])", "$1 $2");
        formated = String.valueOf(formated.substring(0, 1).toUpperCase()) + formated.substring(1);
        return formated;
    }

    protected boolean isFeatureEditable() {
        if (this.getEStructuralFeature() == null) {
            return false;
        }
        String propertyString = this.getAnnotationDetail((ETypedElement)this.getEStructuralFeature(), "property");
        if (propertyString == null) {
            return true;
        }
        if (propertyString.contains("Editable")) {
            return true;
        }
        if (propertyString.contains("None")) {
            return false;
        }
        if (propertyString.contains("Readonly")) {
            return false;
        }
        return false;
    }

    protected Double resolveValue(EObject eObject, FeaturePath featurePath) {
        if (eObject != null && featurePath != null) {
            EStructuralFeature[] features = featurePath.getFeaturePath();
            int i = 0;
            Object object = null;
            EObject currentEObject = eObject;
            while (i < features.length) {
                EStructuralFeature currentFeature = features[i];
                object = currentEObject.eGet(currentFeature);
                if (i + 1 == features.length) {
                    if (object instanceof Number) {
                        Number value = (Number)object;
                        return value.doubleValue();
                    }
                    return null;
                }
                if (object != null) {
                    if (object instanceof EObject) {
                        currentEObject = (EObject)object;
                    }
                } else {
                    return null;
                }
                ++i;
            }
            return null;
        }
        return null;
    }

    protected String getAnnotationDetail(ETypedElement eTypedElement, String key) {
        EMap map;
        EAnnotation annotation = eTypedElement.getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
        if (annotation != null && (map = annotation.getDetails()) != null) {
            return (String)map.get((Object)key);
        }
        return null;
    }

    protected Unit<?> getNativeUnits() {
        return ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)this.getEStructuralFeature());
    }

    protected Unit<?> getDisplayUnits() {
        if (this.getEStructuralFeature() != null) {
            return ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)this.getEStructuralFeature());
        }
        return null;
    }

    protected DecimalFormat getDecimalFormat() {
        if (this.getEStructuralFeature() != null) {
            return ApogyCommonEMFUIFacade.INSTANCE.getDisplayFormat((ETypedElement)this.getEStructuralFeature());
        }
        return null;
    }

    protected Ranges getRange(ETypedElement eTypedElement, Object value) {
        return ApogyCommonEMFFacade.INSTANCE.getRange((ETypedElement)this.getEStructuralFeature(), value);
    }

    protected String getToolTipDescription() {
        String description = "";
        if (this.getEStructuralFeature() != null) {
            Number outsideMaxValue;
            Number outsideMinValue;
            Number maxAlarmValue;
            Number maxWarningValue;
            Number minWarningValue;
            Number minAlarmValue;
            description = String.valueOf(description) + ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)this.getEStructuralFeature());
            Unit nativeUnits = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)this.getEStructuralFeature());
            Unit displayUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)this.getEStructuralFeature());
            if (nativeUnits != null) {
                description = String.valueOf(description) + "Native Units    : " + nativeUnits.toString() + "\n";
            }
            if (displayUnits != null) {
                description = String.valueOf(description) + "Displayed Units : " + displayUnits.toString();
            }
            if ((minAlarmValue = ApogyCommonEMFFacade.INSTANCE.getAlarmMinValue((ETypedElement)this.getEStructuralFeature())) != null) {
                description = String.valueOf(description) + "\nAlarm Minimum Value : ";
                description = nativeUnits != null ? (displayUnits != null ? String.valueOf(description) + this.getDecimalFormat().format(nativeUnits.getConverterTo(displayUnits).convert(minAlarmValue.doubleValue())) + " " + displayUnits.toString() : String.valueOf(description) + this.getDecimalFormat().format(minAlarmValue.doubleValue()) + " " + nativeUnits.toString()) : String.valueOf(description) + this.getDecimalFormat().format(minAlarmValue.doubleValue());
            }
            if ((minWarningValue = ApogyCommonEMFFacade.INSTANCE.getWarningMinValue((ETypedElement)this.getEStructuralFeature())) != null) {
                description = String.valueOf(description) + "\nWarning Minimum Value : ";
                description = nativeUnits != null ? (displayUnits != null ? String.valueOf(description) + this.getDecimalFormat().format(nativeUnits.getConverterTo(displayUnits).convert(minWarningValue.doubleValue())) + " " + displayUnits.toString() : String.valueOf(description) + this.getDecimalFormat().format(minWarningValue.doubleValue()) + " " + nativeUnits.toString()) : String.valueOf(description) + this.getDecimalFormat().format(minWarningValue.doubleValue());
            }
            if ((maxWarningValue = ApogyCommonEMFFacade.INSTANCE.getWarningMaxValue((ETypedElement)this.getEStructuralFeature())) != null) {
                description = String.valueOf(description) + "\nWarning Maximum Value : ";
                description = nativeUnits != null ? (displayUnits != null ? String.valueOf(description) + this.getDecimalFormat().format(nativeUnits.getConverterTo(displayUnits).convert(maxWarningValue.doubleValue())) + " " + displayUnits.toString() : String.valueOf(description) + this.getDecimalFormat().format(maxWarningValue.doubleValue()) + " " + nativeUnits.toString()) : String.valueOf(description) + this.getDecimalFormat().format(maxWarningValue.doubleValue());
            }
            if ((maxAlarmValue = ApogyCommonEMFFacade.INSTANCE.getAlarmMaxValue((ETypedElement)this.getEStructuralFeature())) != null) {
                description = String.valueOf(description) + "\nAlarm Maximum Value : ";
                description = nativeUnits != null ? (displayUnits != null ? String.valueOf(description) + this.getDecimalFormat().format(nativeUnits.getConverterTo(displayUnits).convert(maxAlarmValue.doubleValue())) + " " + displayUnits.toString() : String.valueOf(description) + this.getDecimalFormat().format(maxAlarmValue.doubleValue()) + " " + nativeUnits.toString()) : String.valueOf(description) + this.getDecimalFormat().format(maxAlarmValue.doubleValue());
            }
            if ((outsideMinValue = ApogyCommonEMFFacade.INSTANCE.getOutOfRangeMinValue((ETypedElement)this.getEStructuralFeature())) != null) {
                description = String.valueOf(description) + "\nOut Of Range Minimum Value : ";
                description = nativeUnits != null ? (displayUnits != null ? String.valueOf(description) + this.getDecimalFormat().format(nativeUnits.getConverterTo(displayUnits).convert(outsideMinValue.doubleValue())) + " " + displayUnits.toString() : String.valueOf(description) + this.getDecimalFormat().format(outsideMinValue.doubleValue()) + " " + nativeUnits.toString()) : String.valueOf(description) + this.getDecimalFormat().format(outsideMinValue.doubleValue());
            }
            if ((outsideMaxValue = ApogyCommonEMFFacade.INSTANCE.getOutOfRangeMaxValue((ETypedElement)this.getEStructuralFeature())) != null) {
                description = String.valueOf(description) + "\nOut Of Range Maximum Value : ";
                description = nativeUnits != null ? (displayUnits != null ? String.valueOf(description) + this.getDecimalFormat().format(nativeUnits.getConverterTo(displayUnits).convert(outsideMaxValue.doubleValue())) + " " + displayUnits.toString() : String.valueOf(description) + this.getDecimalFormat().format(outsideMaxValue.doubleValue()) + " " + nativeUnits.toString()) : String.valueOf(description) + this.getDecimalFormat().format(outsideMaxValue.doubleValue());
            }
        }
        return description;
    }

    private void initDataBindingsCustom() {
        this.bindingContext = new DataBindingContext();
        ISWTObservableValue observableValueTextTextValue = WidgetProperties.text((int)16).observe((Widget)this.valueText);
        ISWTObservableValue observableValueBackgroundTextValue = WidgetProperties.background().observe((Widget)this.valueText);
        TransactionalEditingDomain editingDomain = ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain(this.eObject);
        IObservableValue observeTypedElementValue = editingDomain != null ? EMFEditProperties.value((EditingDomain)editingDomain, (FeaturePath)this.featurePath).observe((Object)this.eObject) : EMFProperties.value((FeaturePath)this.featurePath).observe((Object)this.eObject);
        this.colorBinding = this.bindingContext.bindValue((IObservableValue)observableValueBackgroundTextValue, observeTypedElementValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(String.class, Color.class){

            public Object convert(Object fromObject) {
                Color color = ApogyCommonEMFUIFacade.INSTANCE.getColorForRange(TypedElementSimpleUnitsComposite.this.getRange((ETypedElement)TypedElementSimpleUnitsComposite.this.getEStructuralFeature(), TypedElementSimpleUnitsComposite.this.resolveValue(TypedElementSimpleUnitsComposite.this.eObject, TypedElementSimpleUnitsComposite.this.featurePath)));
                return color != null ? color : TypedElementSimpleUnitsComposite.this.getDisplay().getSystemColor(0x40000000);
            }
        }));
        this.valueBinding = this.bindingContext.bindValue((IObservableValue)observableValueTextTextValue, observeTypedElementValue, this.getUpdateModelValueStrategy(), this.getUpdateTextValueStrategy());
        this.valueText.setToolTipText(this.getToolTipDescription());
    }

    private UpdateValueStrategy getUpdateModelValueStrategy() {
        boolean featureEditable = this.isFeatureEditable();
        if (featureEditable) {
            return new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(String.class, this.getEStructuralFeature().getEType().getInstanceClass()){

                public Object convert(Object fromObject) {
                    if (fromObject != null && !"".equals(fromObject)) {
                        try {
                            Number number = ApogyCommonEMFUIFacade.INSTANCE.convertToNativeUnits((Number)Double.parseDouble((String)fromObject), TypedElementSimpleUnitsComposite.this.getNativeUnits(), TypedElementSimpleUnitsComposite.this.getDisplayUnits(), TypedElementSimpleUnitsComposite.this.getEStructuralFeature().getEType());
                            Unit<?> displayUnits = TypedElementSimpleUnitsComposite.this.getDisplayUnits();
                            Unit<?> nativeUnits = TypedElementSimpleUnitsComposite.this.getNativeUnits();
                            DecimalFormat format = TypedElementSimpleUnitsComposite.this.getDecimalFormat();
                            if (displayUnits != null && !displayUnits.equals(nativeUnits)) {
                                TypedElementSimpleUnitsComposite.this.valueText.setText(format.format(nativeUnits.getConverterTo(displayUnits).convert(number.doubleValue())));
                            } else {
                                TypedElementSimpleUnitsComposite.this.valueText.setText(format.format(number.doubleValue()));
                            }
                            EClassifier classifier = TypedElementSimpleUnitsComposite.this.getEStructuralFeature().getEType();
                            if (classifier == EcorePackage.Literals.EFLOAT) {
                                number = Float.valueOf(number.floatValue());
                            } else if (classifier == EcorePackage.Literals.EBYTE) {
                                number = number.byteValue();
                            } else if (classifier == EcorePackage.Literals.ESHORT) {
                                number = number.shortValue();
                            } else if (classifier == EcorePackage.Literals.EINT) {
                                number = number.intValue();
                            } else if (classifier == EcorePackage.Literals.ELONG) {
                                number = number.longValue();
                            }
                            return number;
                        }
                        catch (Exception e) {
                            Logger.error(e.getMessage(), (Throwable)e);
                            MessageDialog.openError((Shell)TypedElementSimpleUnitsComposite.this.getShell(), (String)"Invalid Number", (String)"The number entered is invalid. The value will be unset.");
                        }
                    }
                    TypedElementSimpleUnitsComposite.this.valueText.setText(TypedElementSimpleUnitsComposite.this.getFormatedValue());
                    return TypedElementSimpleUnitsComposite.this.eObject.eGet(TypedElementSimpleUnitsComposite.this.getEStructuralFeature());
                }
            });
        }
        return new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER);
    }

    private UpdateValueStrategy getUpdateTextValueStrategy() {
        return new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(this.getEStructuralFeature().getEType().getInstanceClass(), String.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    String value = TypedElementSimpleUnitsComposite.this.getFormatedValue();
                    return value == null ? "" : value;
                }
                return "";
            }
        });
    }

    private IPropertyChangeListener getPropertyChangeListener() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event != null && event.getProperty() != null) {
                        if (event.getProperty().equals("TYPED_ELEMENTS_UNITS_ID") || PreferencesConstants.isFormatPreference((String)event.getProperty())) {
                            if (TypedElementSimpleUnitsComposite.this.valueBinding != null) {
                                TypedElementSimpleUnitsComposite.this.valueBinding.updateModelToTarget();
                            }
                            TypedElementSimpleUnitsComposite.this.updateButton();
                            TypedElementSimpleUnitsComposite.this.updateUnitsLabel();
                            TypedElementSimpleUnitsComposite.this.updateValueTooltip();
                        } else if ((event.getProperty().equals(Ranges.UNKNOWN.getName()) || event.getProperty().equals(Ranges.NOMINAL.getName()) || event.getProperty().equals(Ranges.WARNING.getName()) || event.getProperty().equals(Ranges.ALARM.getName()) || event.getProperty().equals(Ranges.OUT_OF_RANGE.getName())) && TypedElementSimpleUnitsComposite.this.colorBinding != null) {
                            TypedElementSimpleUnitsComposite.this.colorBinding.updateModelToTarget();
                        }
                    }
                }
            };
        }
        return this.propertyChangeListener;
    }

    private void updateButton() {
        if (this.unitsButton != null && !this.unitsButton.isDisposed()) {
            try {
                Unit<?> units = this.getDisplayUnits();
                if (units != null) {
                    this.unitsButton.setText(units.toString());
                    GC gc = new GC((Drawable)this);
                    int width = (int)((double)gc.getFontMetrics().getLeading() + gc.getFontMetrics().getAverageCharacterWidth() * (double)units.toString().length() + 20.0);
                    GridData gd_buttonUnits = new GridData(4, 0x1000000, true, false, 1, 1);
                    gd_buttonUnits.widthHint = width;
                    gd_buttonUnits.minimumWidth = width;
                    this.unitsButton.setLayoutData((Object)gd_buttonUnits);
                } else {
                    this.unitsButton.setText("Units");
                }
                this.layout(true, true);
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
    }

    private void updateValueTooltip() {
        if (this.valueText != null && !this.valueText.isDisposed()) {
            this.valueText.setToolTipText(this.getToolTipDescription());
        }
    }

    private void updateUnitsLabel() {
        if (this.unitsLabel != null && !this.unitsLabel.isDisposed()) {
            Unit<?> units = this.getDisplayUnits();
            if (units != null) {
                this.unitsLabel.setText(units.toString());
                GC gc = new GC((Drawable)this);
                int width = (int)((double)gc.getFontMetrics().getLeading() + gc.getFontMetrics().getAverageCharacterWidth() * (double)units.toString().length() + 10.0);
                GridData gd_buttonUnits = new GridData(4, 0x1000000, true, false, 1, 1);
                gd_buttonUnits.widthHint = width;
                this.unitsLabel.setLayoutData((Object)gd_buttonUnits);
            } else {
                this.unitsLabel.setText("?");
            }
            this.unitsLabel.requestLayout();
            this.requestLayout();
        }
    }

    private String getFormatedValue() {
        Double valueDouble = this.resolveValue(this.eObject, this.featurePath);
        if (valueDouble != null) {
            DecimalFormat format = this.getDecimalFormat();
            Unit displayUnits = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)this.getEStructuralFeature());
            Unit nativeUnits = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)this.getEStructuralFeature());
            if (displayUnits != null && !displayUnits.equals((Object)nativeUnits)) {
                valueDouble = nativeUnits.getConverterTo(displayUnits).convert(valueDouble.doubleValue());
            }
            return format.format(valueDouble);
        }
        return this.getNoValueText();
    }
}

