/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.renderers;

import java.util.ArrayList;
import org.eclipse.emf.ecp.view.model.common.AbstractGridCell;
import org.eclipse.emf.ecp.view.model.common.AbstractRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.SWTDataElementIdHelper;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractCustomElementSWTRenderer
extends AbstractSWTRenderer<VContainedElement> {
    private SWTGridDescription rendererGridDescription;

    public AbstractCustomElementSWTRenderer(VContainedElement vElement, ViewModelContext viewContext, ReportService reportService) {
        super((VElement)vElement, viewContext, reportService);
    }

    protected void dispose() {
        this.rendererGridDescription = null;
        super.dispose();
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            int columns = 3;
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createEmptyGridDescription();
            this.rendererGridDescription.setRows(1);
            this.rendererGridDescription.setColumns(3);
            ArrayList<SWTGridCell> grid = new ArrayList<SWTGridCell>();
            SWTGridCell labelCell = this.createLabelCell(grid.size());
            grid.add(labelCell);
            SWTGridCell validationCell = this.createValidationCell(grid.size());
            grid.add(validationCell);
            SWTGridCell controlCell = this.createControlCell(grid.size());
            grid.add(controlCell);
            this.rendererGridDescription.setGrid(grid);
        }
        return this.rendererGridDescription;
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) {
        int controlIndex = cell.getColumn();
        switch (controlIndex) {
            case 0: {
                return this.createLabel(parent);
            }
            case 1: {
                return this.createValidationIcon(parent);
            }
            case 2: {
                return this.createControl(parent);
            }
        }
        throw new IllegalArgumentException(String.format("The provided SWTGridCell (%1$s) cannot be used by this (%2$s) renderer.", cell.toString(), ((Object)((Object)this)).toString()));
    }

    protected Control createLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(this.getLabelText());
        return label;
    }

    protected String getLabelText() {
        return this.getViewModelContext().getDomainModel().eClass().getName();
    }

    protected Label createValidationIcon(Composite composite) {
        Label validationLabel = new Label(composite, 0);
        SWTDataElementIdHelper.setElementIdDataWithSubId((Widget)validationLabel, (VElement)this.getVElement(), (String)"control_validation", (ViewModelContext)this.getViewModelContext());
        validationLabel.setBackground(composite.getBackground());
        return validationLabel;
    }

    protected abstract Control createControl(Composite var1);

    protected SWTGridCell createLabelCell(int column) {
        SWTGridCell labelCell = new SWTGridCell(0, column, (AbstractSWTRenderer)this);
        labelCell.setHorizontalGrab(false);
        labelCell.setVerticalGrab(false);
        labelCell.setHorizontalFill(false);
        labelCell.setHorizontalAlignment(AbstractGridCell.Alignment.BEGINNING);
        labelCell.setVerticalFill(false);
        labelCell.setVerticalAlignment(AbstractGridCell.Alignment.CENTER);
        labelCell.setRenderer((AbstractRenderer)this);
        return labelCell;
    }

    protected SWTGridCell createValidationCell(int column) {
        SWTGridCell validationCell = new SWTGridCell(0, column, (AbstractSWTRenderer)this);
        validationCell.setHorizontalGrab(false);
        validationCell.setVerticalGrab(false);
        validationCell.setHorizontalFill(false);
        validationCell.setHorizontalAlignment(AbstractGridCell.Alignment.CENTER);
        validationCell.setVerticalFill(false);
        validationCell.setVerticalAlignment(AbstractGridCell.Alignment.CENTER);
        validationCell.setRenderer((AbstractRenderer)this);
        validationCell.setPreferredSize(10, 10);
        return validationCell;
    }

    protected SWTGridCell createControlCell(int column) {
        SWTGridCell controlCell = new SWTGridCell(0, column, (AbstractSWTRenderer)this);
        controlCell.setHorizontalGrab(true);
        controlCell.setVerticalGrab(false);
        controlCell.setHorizontalFill(true);
        controlCell.setVerticalFill(false);
        controlCell.setVerticalAlignment(AbstractGridCell.Alignment.CENTER);
        controlCell.setRenderer((AbstractRenderer)this);
        return controlCell;
    }
}

