/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.renderers;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.emfforms.ApogyCommonEMFUiEMFFormsFacade;
import org.eclipse.apogy.common.emf.ui.emfforms.PropertyType;
import org.eclipse.apogy.common.emf.ui.emfforms.dialogs.SelectDateDialog;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.SimpleControlSWTControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateControlCompositeRenderer
extends SimpleControlSWTControlSWTRenderer {
    private static final Logger Logger = LoggerFactory.getLogger(DateControlCompositeRenderer.class);
    protected Text textValue;
    private Button buttonEdit;
    private Binding valueBinding;
    private Binding toolTipBinding;

    @Inject
    public DateControlCompositeRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    protected Binding[] createBindings(Control control) throws DatabindingFailedException {
        Binding[] bindings = new Binding[2];
        ISWTObservableValue textValueText = WidgetProperties.text((int)16).observe((Widget)this.textValue);
        bindings[0] = this.valueBinding = this.getDataBindingContext().bindValue((IObservableValue)textValueText, this.getModelValue(), this.getUpdateModelValueStrategy(), this.getUpdateTextValueStrategy());
        ISWTObservableValue textToolTip = WidgetProperties.tooltipText().observe((Widget)this.textValue);
        bindings[1] = this.toolTipBinding = this.getDataBindingContext().bindValue((IObservableValue)textToolTip, this.getModelValue(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(EObject.class, String.class){

            public Object convert(Object fromObject) {
                String toolTip = ApogyCommonEMFFacade.INSTANCE.getFullDescription(DateControlCompositeRenderer.this.getTypedElement());
                return toolTip;
            }
        }));
        return bindings;
    }

    protected Control createSWTControl(Composite parent) throws DatabindingFailedException {
        PropertyType propertyType = this.getPropertyType(this.getVElement());
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).create());
        main.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        main.setBackground(parent.getBackground());
        main.setBackgroundMode(2);
        this.textValue = new Text(main, 133120);
        this.textValue.setEditable(propertyType == PropertyType.EDITABLE);
        GridData gd_textValue = new GridData(4, 4, true, true, 1, 1);
        gd_textValue.widthHint = 200;
        this.textValue.setLayoutData((Object)gd_textValue);
        this.buttonEdit = new Button(main, 8);
        this.buttonEdit.setText("Edit...");
        this.buttonEdit.setEnabled(propertyType == PropertyType.EDITABLE);
        GridData gd_buttonUnits = new GridData(4, 4, false, true, 1, 1);
        gd_buttonUnits.minimumWidth = 70;
        gd_buttonUnits.widthHint = 70;
        this.buttonEdit.setLayoutData((Object)gd_buttonUnits);
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectDateDialog dialog = new SelectDateDialog(DateControlCompositeRenderer.this.buttonEdit.getShell(), DateControlCompositeRenderer.this.getValue());
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    try {
                        DateControlCompositeRenderer.this.getModelValue().setValue((Object)dialog.getSelectedDate());
                        DateControlCompositeRenderer.this.textValue.setText(DateControlCompositeRenderer.this.getFormatedValue(dialog.getSelectedDate()));
                        DateControlCompositeRenderer.this.textValue.setToolTipText(DateControlCompositeRenderer.this.getFormatedValue(dialog.getSelectedDate()));
                    }
                    catch (DatabindingFailedException e1) {
                        Logger.error("Failed to set date!", (Throwable)e1);
                    }
                }
            }
        });
        return main;
    }

    protected String getUnsetText() {
        return "unset";
    }

    protected UpdateValueStrategy getUpdateTextValueStrategy() {
        return new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(this.getTypedElement().getEType().getInstanceClass(), String.class){

            public Object convert(Object fromObject) {
                if (fromObject instanceof Date) {
                    Date date = (Date)fromObject;
                    String value = ApogyCommonEMFFacade.INSTANCE.format(date);
                    DateControlCompositeRenderer.this.textValue.setToolTipText(value);
                    return value == null ? "" : value;
                }
                return "";
            }
        });
    }

    protected UpdateValueStrategy getUpdateModelValueStrategy() {
        PropertyType propertyType = this.getPropertyType(this.getVElement());
        if (propertyType == PropertyType.EDITABLE) {
            return new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(String.class, this.getTypedElement().getEType().getInstanceClass()){

                public Object convert(Object fromObject) {
                    if (fromObject != null && !"".equals(fromObject)) {
                        try {
                            String dateFormatString = ApogyCommonEMFFacade.INSTANCE.getDateFormatString();
                            SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatString);
                            Date date = dateFormat.parse((String)fromObject);
                            return date;
                        }
                        catch (Exception e) {
                            MessageDialog.openError((Shell)DateControlCompositeRenderer.this.textValue.getDisplay().getActiveShell(), (String)"Invalid Date", (String)"The date string entered is invalid. The value will be unset.");
                        }
                    }
                    DateControlCompositeRenderer.this.textValue.setText(DateControlCompositeRenderer.this.getFormatedValue());
                    DateControlCompositeRenderer.this.textValue.setToolTipText(DateControlCompositeRenderer.this.getFormatedValue());
                    return DateControlCompositeRenderer.this.getValue();
                }
            });
        }
        return new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER);
    }

    protected Date getValue() {
        try {
            return (Date)this.getModelValue().getValue();
        }
        catch (DatabindingFailedException e) {
            Logger.error("Error getting the value.");
            return null;
        }
    }

    protected String getFormatedValue() {
        return this.getFormatedValue(this.getValue());
    }

    protected String getFormatedValue(Date date) {
        if (date != null) {
            return ApogyCommonEMFFacade.INSTANCE.format(date);
        }
        return "";
    }

    protected PropertyType getPropertyType(VElement vElement) {
        VControl vControl;
        PropertyType propertyType = PropertyType.EDITABLE;
        if (vElement instanceof VControl && (vControl = (VControl)vElement).getDomainModelReference() instanceof VFeaturePathDomainModelReference) {
            VFeaturePathDomainModelReference vFeaturePathDomainModelReference = (VFeaturePathDomainModelReference)vControl.getDomainModelReference();
            EStructuralFeature feature = vFeaturePathDomainModelReference.getDomainModelEFeature();
            if (feature.isDerived() || !feature.isChangeable()) {
                propertyType = PropertyType.READONLY;
            } else if (feature instanceof EAttribute) {
                propertyType = ApogyCommonEMFUiEMFFormsFacade.INSTANCE.getPropertyType((EAttribute)feature);
            } else if (feature instanceof EReference) {
                propertyType = ApogyCommonEMFUiEMFFormsFacade.INSTANCE.getPropertyType((EReference)feature);
            }
        }
        return propertyType;
    }

    protected ETypedElement getTypedElement() {
        try {
            return (ETypedElement)this.getModelValue().getValueType();
        }
        catch (DatabindingFailedException e) {
            Logger.error("Error getting the typedElement");
            return null;
        }
    }
}

