/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.emf.ui.composites.AbstractECollectionComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.AbstractWizardPage;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractECollectionWizardPage<RootEObject extends EObject, ResolvedEObject extends EObject, ItemObject extends EObject>
extends AbstractWizardPage<RootEObject, ResolvedEObject, ItemObject> {
    private AbstractECollectionComposite<RootEObject, ResolvedEObject, ItemObject> composite;
    private EStructuralFeature eStructuralFeature;

    public AbstractECollectionWizardPage(String id, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        super(id, featurePath);
        this.eStructuralFeature = eStructuralFeature;
        this.setTitle("Select an element");
        this.setDescription("Select an element from the list.");
    }

    @Override
    public EStructuralFeature getEStructuralFeature() {
        return this.eStructuralFeature;
    }

    @Override
    public void createControl(Composite parent) {
        this.composite = this.createContentComposite(parent, 0);
        this.composite.addSelectionChangedListener(e -> this.selectionChanged(this.getCurrentSelection()));
        this.setControl((Control)this.composite);
        this.composite.setRootEObject(this.getRootEObject());
    }

    @Override
    public void internalRootEObjectChanged(RootEObject rootEObject) {
        if (this.composite != null) {
            this.composite.setRootEObject(this.getRootEObject());
        }
    }

    protected abstract AbstractECollectionComposite<RootEObject, ResolvedEObject, ItemObject> createContentComposite(Composite var1, int var2);

    protected void selectionChanged(IStructuredSelection currentSelection) {
        this.validate();
    }

    protected List<ItemObject> getSelectedItemObjects() {
        ArrayList list = new ArrayList();
        if (this.getCurrentSelection() != null) {
            list.addAll(this.getCurrentSelection().toList());
        }
        return list;
    }

    public final IStructuredSelection getCurrentSelection() {
        return this.composite == null ? null : this.composite.getCurrentSelection();
    }

    @Override
    protected void validate() {
        String errorMessage = this.getCurrentSelection() != null ? null : "An element must be selected";
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }
}

