/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.wizards;

import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ENamedElementReferencesList;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.WizardPagesProvider;
import org.eclipse.apogy.common.emf.ui.WizardPagesProviderRegistry;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.AbstractApogyWizard;
import org.eclipse.apogy.common.emf.ui.emfforms.wizards.ENamedElementsListWizardPage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;

public class EObjectWizard<RootEObject extends EObject, ResolvedEObject extends EObject, ItemObject>
extends AbstractApogyWizard<RootEObject, ResolvedEObject, ItemObject> {
    private EClass eClass;
    private int firstProvidedPageIndex;
    private int lastProvidedPageIndex;
    private ENamedElementsListWizardPage<ENamedElementReferencesList<EStructuralFeature>, EStructuralFeature> eReferencesListWizardPage;
    private ENamedElementsListWizardPage<ENamedElementReferencesList<EClass>, EClass> eClassesListWizardPage;
    private WizardPagesProvider pagesProvider;

    public EObjectWizard(RootEObject rootObject) {
        this(rootObject, null, null, null, null);
    }

    public EObjectWizard(RootEObject rootObject, EClassSettings settings) {
        this(rootObject, null, null, null, settings);
    }

    public EObjectWizard(RootEObject rootObject, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        this(rootObject, featurePath, eStructuralFeature, null, null);
    }

    public EObjectWizard(RootEObject rootObject, FeaturePath featurePath, EStructuralFeature eStructuralFeature, EClassSettings settings) {
        this(rootObject, featurePath, eStructuralFeature, null, settings);
    }

    public EObjectWizard(RootEObject rootObject, FeaturePath featurePath, EStructuralFeature eStructuralFeature, EClass eClass, EClassSettings settings) {
        super(rootObject, featurePath, eStructuralFeature, settings);
        this.eClass = eClass;
        this.firstProvidedPageIndex = 0;
        this.lastProvidedPageIndex = 0;
    }

    public void addPages() {
        if (this.getEStructuralFeature() == null) {
            this.eReferencesListWizardPage = new ENamedElementsListWizardPage<ENamedElementReferencesList<EStructuralFeature>, EStructuralFeature>(null){

                @Override
                protected void selectionChanged(IStructuredSelection currentSelection) {
                    EReference eReference;
                    List items = this.getSelectedItemObjects();
                    if (!items.isEmpty() && items.get(0) instanceof EReference && (eReference = (EReference)items.get(0)).getEReferenceType() instanceof EClass) {
                        EObjectWizard.this.populateSubclasses(eReference.getEReferenceType());
                    }
                }
            };
            this.addPage((IWizardPage)this.eReferencesListWizardPage);
            ENamedElementReferencesList list = ApogyCommonEMFFactory.eINSTANCE.createENamedElementReferencesList();
            list.getENamedElements().addAll((Collection)this.getResolvedObject().eClass().getEAllReferences());
            this.eReferencesListWizardPage.setRootEObject(list);
        }
        if (this.eClass == null) {
            this.eClassesListWizardPage = new ENamedElementsListWizardPage<ENamedElementReferencesList<EClass>, EClass>(null){

                @Override
                protected void selectionChanged(IStructuredSelection currentSelection) {
                    List items = this.getSelectedItemObjects();
                    if (!items.isEmpty()) {
                        EObjectWizard.this.populateContributedPages((EClass)items.get(0));
                    }
                }
            };
            this.addPage((IWizardPage)this.eClassesListWizardPage);
            this.populateSubclasses(this.getEClass(this.getEStructuralFeature()));
        } else {
            this.populateContributedPages(this.eClass);
        }
    }

    public EClass getEClass(EStructuralFeature eStructuralFeature) {
        EClass eClass = null;
        if (eStructuralFeature instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            eClass = eReference.getEReferenceType() instanceof EClass ? eReference.getEReferenceType() : null;
        }
        return eClass;
    }

    private void populateSubclasses(EClass eClass) {
        if (eClass != null) {
            SortedSet subEClasses = ApogyCommonEMFFacade.INSTANCE.sortAlphabetically(ApogyCommonEMFFacade.INSTANCE.getAllSubEClasses(eClass));
            ENamedElementReferencesList list = ApogyCommonEMFFactory.eINSTANCE.createENamedElementReferencesList();
            list.getENamedElements().addAll((Collection)subEClasses);
            this.eClassesListWizardPage.setRootEObject(list);
        }
    }

    private void populateContributedPages(EClass eClass) {
        this.pagesProvider = WizardPagesProviderRegistry.INSTANCE.getProvider(eClass);
        EList providedWizardPages = this.pagesProvider.getPages(eClass, this.getEClassSettings());
        this.firstProvidedPageIndex = this.getPages().length;
        this.lastProvidedPageIndex = this.getPages().length + providedWizardPages.size();
        this.eClass = eClass;
        for (WizardPage page : providedWizardPages) {
            this.addPage((IWizardPage)page);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = null;
        if (page == this.eClassesListWizardPage && this.firstProvidedPageIndex != 0 && this.firstProvidedPageIndex != this.lastProvidedPageIndex) {
            nextPage = this.getPages()[this.firstProvidedPageIndex];
        }
        return nextPage == null ? super.getNextPage(page) : nextPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        Object previousPage = null;
        if (page == this.getPages()[this.firstProvidedPageIndex] && this.eClassesListWizardPage != null) {
            previousPage = this.eClassesListWizardPage;
        }
        return previousPage == null ? super.getPreviousPage(page) : previousPage;
    }

    public Object getCreatedEObject() {
        return this.pagesProvider == null ? null : this.pagesProvider.getEObject();
    }

    public boolean performFinish() {
        EStructuralFeature eStructuralFeature;
        EStructuralFeature eStructuralFeature2 = eStructuralFeature = this.getEStructuralFeature() != null ? this.getEStructuralFeature() : (EStructuralFeature)this.eReferencesListWizardPage.getSelectedItemObjects().get(0);
        if (eStructuralFeature.isMany()) {
            ApogyCommonTransactionFacade.INSTANCE.basicAdd(this.getResolvedObject(), eStructuralFeature, this.getCreatedEObject(), true);
        } else {
            ApogyCommonTransactionFacade.INSTANCE.basicSet(this.getResolvedObject(), eStructuralFeature, this.getCreatedEObject(), true);
        }
        return true;
    }

    public boolean canFinish() {
        if (this.eReferencesListWizardPage != null && !this.eReferencesListWizardPage.isPageComplete()) {
            return false;
        }
        if (this.eClassesListWizardPage != null && !this.eClassesListWizardPage.isPageComplete()) {
            return false;
        }
        if (this.firstProvidedPageIndex != this.lastProvidedPageIndex) {
            int i = this.firstProvidedPageIndex;
            while (i < this.lastProvidedPageIndex) {
                if (!this.getPages()[i].isPageComplete()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public IWizardPage[] getPages() {
        return super.getPages();
    }
}

