/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.composites;

import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EObjectCompositeSettings;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEObjectComposite<RootEObject extends EObject, ResolvedEObject extends EObject, ItemObject>
extends Composite {
    private final FormToolkit formToolkit = new FormToolkit(Display.getCurrent());
    private static final Logger Logger = LoggerFactory.getLogger(AbstractEObjectComposite.class);
    private static final String RESOLUTION_ERROR_MESSAGE = "%s: RUNTIME ERROR!!! Unable to resolve:\n-RootObject: %s\n-FeaturePath: %s.";
    private WritableValue<RootEObject> rootEObjectWritableValue;
    private FeaturePath featurePath;
    private EStructuralFeature eStructuralFeature;
    private ResolvedEObject resolvedEObject = null;
    private DataBindingContext dataBindingContext = new DataBindingContext();
    protected Composite parentComposite;
    private AdapterImpl resolvedEObjectAdapter;
    private ScrolledComposite contentCompositeWrapper;
    private Composite contentComposite;
    private FillLayout contentCompositeWrapperLayout;
    private EObjectCompositeSettings settings;

    public AbstractEObjectComposite(Composite parent, int style, FeaturePath featurePath) {
        this(parent, style, featurePath, null, null);
    }

    public AbstractEObjectComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature) {
        this(parent, style, featurePath, eStructuralFeature, null);
    }

    public AbstractEObjectComposite(Composite parent, int style, FeaturePath featurePath, EStructuralFeature eStructuralFeature, EObjectCompositeSettings settings) {
        super(parent, style);
        this.rootEObjectWritableValue = new WritableValue();
        this.featurePath = featurePath;
        this.eStructuralFeature = eStructuralFeature;
        this.settings = settings;
        if (settings == null) {
            this.settings = this.createDefaultSettings();
        }
        this.addListener(12, e -> {
            if (this.resolvedEObject != null) {
                this.resolvedEObject.eAdapters().remove((Object)this.getResolvedEObjectAdapter());
            }
            this.getFormToolkit().dispose();
        });
        this.parentComposite = parent;
        this.setLayout((Layout)new FillLayout());
        this.contentCompositeWrapper = new ScrolledComposite((Composite)this, 2816);
        this.contentCompositeWrapper.setAlwaysShowScrollBars(false);
        this.contentCompositeWrapper.setExpandVertical(true);
        this.contentCompositeWrapper.setExpandHorizontal(true);
        this.contentCompositeWrapperLayout = new FillLayout();
        this.contentCompositeWrapperLayout.marginHeight = 0;
        this.contentCompositeWrapperLayout.marginWidth = 0;
        this.contentCompositeWrapper.setLayout((Layout)new FillLayout());
        this.contentComposite = this.createContentComposite((Composite)this.contentCompositeWrapper, 0);
        this.contentCompositeWrapper.setContent((Control)this.contentComposite);
        this.rootEObjectWritableValue.addValueChangeListener(s -> {
            this.updateRootEObject(this.getRootEObject(), this.getFeaturePath());
            this.internalRootEObjectChanged(this.getRootEObject(), this.getResolvedEObject());
            this.rootEObjectChanged(this.getRootEObject());
        });
    }

    protected abstract Composite createContentComposite(Composite var1, int var2);

    public final WritableValue<RootEObject> getRootEObjectWritableValue() {
        return this.rootEObjectWritableValue;
    }

    public final RootEObject getRootEObject() {
        return (RootEObject)((EObject)this.rootEObjectWritableValue.getValue());
    }

    public void setRootEObject(RootEObject rootEObject) {
        this.rootEObjectWritableValue.setValue(rootEObject);
    }

    public final FeaturePath getFeaturePath() {
        return this.featurePath;
    }

    public final EStructuralFeature getEStructuralFeature() {
        return this.eStructuralFeature;
    }

    public final EObjectCompositeSettings getCompositeSettings() {
        return this.settings != null ? this.settings : this.createDefaultSettings();
    }

    protected EObjectCompositeSettings createDefaultSettings() {
        return ApogyCommonEMFUIFactory.eINSTANCE.createEObjectCompositeSettings();
    }

    public final DataBindingContext getDataBindingContext() {
        return this.dataBindingContext;
    }

    protected void updateRootEObject(RootEObject rootEObject, FeaturePath featurePath) {
        if (this.resolvedEObject != null) {
            this.resolvedEObject.eAdapters().remove((Object)this.getResolvedEObjectAdapter());
        }
        if (rootEObject == null) {
            this.resolvedEObject = null;
        } else {
            this.resolvedEObject = this.processResolvedEObject(rootEObject, featurePath);
            if (this.resolvedEObject == null) {
                Logger.error(String.format(RESOLUTION_ERROR_MESSAGE, ((Object)((Object)this)).getClass().getName(), rootEObject, this.getFeaturePath()));
            }
        }
        if (this.resolvedEObject != null) {
            this.resolvedEObject.eAdapters().add((Object)this.getResolvedEObjectAdapter());
        }
    }

    protected ResolvedEObject processResolvedEObject(RootEObject rootEObject, FeaturePath featurePath) {
        return (ResolvedEObject)ApogyCommonEMFFacade.INSTANCE.resolveOwner(rootEObject, featurePath);
    }

    public ResolvedEObject getResolvedEObject() {
        return this.resolvedEObject;
    }

    protected void internalRootEObjectChanged(RootEObject rootObject, ResolvedEObject resolvedEObject) {
    }

    protected void rootEObjectChanged(RootEObject rootObject) {
    }

    private Adapter getResolvedEObjectAdapter() {
        if (this.resolvedEObjectAdapter == null) {
            this.resolvedEObjectAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    AbstractEObjectComposite.this.getRootEObjectWritableValue().getRealm().asyncExec(() -> AbstractEObjectComposite.this.setRootEObject(AbstractEObjectComposite.this.getRootEObject()));
                }
            };
        }
        return this.resolvedEObjectAdapter;
    }

    public FormToolkit getFormToolkit() {
        return this.formToolkit;
    }
}

