/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.converters;

import java.text.NumberFormat;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.databinding.converters.AbstractNumberConverter;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.Activator;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractNativeToDisplayConverter
extends AbstractNumberConverter
implements IPropertyChangeListener {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractNativeToDisplayConverter.class);
    private final EStructuralFeature eStructuralFeature;
    private Boolean unitsAreDefined = null;
    private Boolean unitsAreValid = null;
    private Unit<?> nativeUnit = null;
    private Unit<?> displayUnit = null;

    public AbstractNativeToDisplayConverter(EStructuralFeature eStructuralFeature, NumberFormat numberFormat) {
        this.eStructuralFeature = eStructuralFeature;
        this.setNumberFormat(numberFormat);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public AbstractNativeToDisplayConverter(EStructuralFeature eStructuralFeature) {
        this(eStructuralFeature, null);
    }

    public Object convert(Object fromObject) {
        if (fromObject instanceof Number) {
            double nativeValue;
            double displayedValue = nativeValue = ((Number)fromObject).doubleValue();
            if (this.areUnitsValid()) {
                displayedValue = this.getNativeUnit().getConverterTo(this.getDisplayUnit()).convert(nativeValue);
            }
            if (this.getNumberFormat() != null) {
                return this.getNumberFormat().format(displayedValue);
            }
            return Double.toString(displayedValue);
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.displayUnit = null;
    }

    public Unit<?> getDisplayUnit() {
        if (this.displayUnit == null) {
            this.displayUnit = ApogyCommonEMFUIFacade.INSTANCE.getDisplayUnits((ETypedElement)this.eStructuralFeature);
        }
        return this.displayUnit;
    }

    public Unit<?> getNativeUnit() {
        if (this.nativeUnit == null) {
            this.nativeUnit = ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)this.eStructuralFeature);
        }
        return this.nativeUnit;
    }

    public boolean areUnitsDefined() {
        if (this.unitsAreDefined == null) {
            this.unitsAreDefined = new Boolean(this.getNativeUnit() != null && this.getDisplayUnit() != null);
        }
        return this.unitsAreDefined;
    }

    public boolean areUnitsValid() {
        if (this.unitsAreValid == null) {
            this.unitsAreValid = Boolean.FALSE;
            if (this.areUnitsDefined()) {
                try {
                    this.getNativeUnit().getConverterTo(this.getDisplayUnit());
                    this.unitsAreValid = true;
                }
                catch (Throwable e) {
                    String featureID = String.valueOf(this.eStructuralFeature.getEContainingClass().getInstanceClassName()) + "." + this.eStructuralFeature.getName();
                    Logger.error("Invalid Units for feature <" + featureID + "> : Display Unit <" + this.getDisplayUnit().toString() + "> is not compatible with Native Unit <" + this.getNativeUnit().toString() + ">", e);
                }
            }
        }
        return this.unitsAreValid;
    }

    protected void finalize() throws Throwable {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.finalize();
    }
}

