/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.apogy.common.emf.ui.adapters.TimeSourceCompositeProvider;
import org.eclipse.apogy.common.emf.ui.utils.ClassComparator;

public class TimeSourceCompositeProviderFactory {
    private SortedSet<Class<?>> classes;
    private Map<Class<?>, TimeSourceCompositeProvider> classesToAdapterMap;
    private final List<TimeSourceCompositeProvider> adapters;

    public TimeSourceCompositeProviderFactory(List<TimeSourceCompositeProvider> adapters) {
        this.adapters = adapters;
    }

    public TimeSourceCompositeProvider getAdapterFor(Object obj) {
        TimeSourceCompositeProvider adapter = null;
        boolean found = false;
        Iterator iterator = this.getClasses().iterator();
        while (iterator.hasNext() && !found) {
            Class adaptedClass = (Class)iterator.next();
            if (!adaptedClass.isAssignableFrom(obj.getClass())) continue;
            found = true;
            adapter = this.getClassesToAdapterMap().get(adaptedClass);
        }
        return adapter;
    }

    private SortedSet<Class<?>> getClasses() {
        this.classes = new TreeSet(new ClassComparator());
        for (TimeSourceCompositeProvider adapter : this.adapters) {
            this.getClassesToAdapterMap().put(adapter.getAdaptedClass(), adapter);
            this.classes.add(adapter.getAdaptedClass());
        }
        return this.classes;
    }

    private Map<Class<?>, TimeSourceCompositeProvider> getClassesToAdapterMap() {
        if (this.classesToAdapterMap == null) {
            this.classesToAdapterMap = new HashMap();
        }
        return this.classesToAdapterMap;
    }
}

