/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.pif;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Color4b;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import org.eclipse.apogy.common.geometry.data3d.pif.PifHeader;

public class PifReader {
    private List<Point3f> points;
    private DataInputStream din = null;
    private PifHeader header = null;
    private List<Color4b> colors = null;

    public PifReader(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(new File(fileName));
        BufferedInputStream is = new BufferedInputStream(fis);
        this.din = new DataInputStream(is);
        this.processData();
    }

    private void processData() throws IOException {
        this.readHeader();
        this.readPoints();
        this.readColors();
    }

    public PifReader(InputStream in) throws IOException {
        BufferedInputStream is = new BufferedInputStream(in);
        this.din = new DataInputStream(is);
        this.processData();
    }

    private void readColors() throws IOException {
        this.colors = new ArrayList<Color4b>(this.header.getArrayHeight() * this.header.getArrayWidth());
        System.out.println("Image flag: " + this.header.getImageColorFlag());
        if (this.header.getImageColorFlag() != 0) {
            int i = 0;
            while (i < this.header.getArrayHeight() * this.header.getArrayWidth()) {
                Color4b nextColor = null;
                byte a = 0;
                byte b = 0;
                byte g = 0;
                byte r = 0;
                switch (this.header.getImageColorFlag()) {
                    case 1: {
                        byte value;
                        g = b = (value = this.din.readByte());
                        r = b;
                        a = 1;
                        break;
                    }
                    case 3: {
                        r = this.din.readByte();
                        g = this.din.readByte();
                        b = this.din.readByte();
                        a = 1;
                        break;
                    }
                    case 4: {
                        r = this.din.readByte();
                        g = this.din.readByte();
                        b = this.din.readByte();
                        a = this.din.readByte();
                        break;
                    }
                    default: {
                        System.err.println("Invalid image color flag");
                    }
                }
                nextColor = new Color4b(r, g, b, a);
                this.colors.add(nextColor);
                ++i;
            }
        }
    }

    private void readHeader() throws IOException {
        this.header = new PifHeader();
        byte[] buffer = new byte[64];
        this.din.readFully(buffer, 0, 64);
        this.header.setFormatVersion(new String(buffer));
        buffer = new byte[128];
        this.din.readFully(buffer, 0, 128);
        this.header.setUserComments(new String(buffer));
        buffer = new byte[8];
        this.din.readFully(buffer, 0, 8);
        this.header.setDummy1(new String(buffer));
        int imageParamFlag = this.din.readInt();
        this.header.setImageParamFlag(imageParamFlag);
        int imageDataType = this.din.readInt();
        this.header.setImageDataType(imageDataType);
        float invalidPoint = this.din.readFloat();
        this.header.setInvalidPoint(invalidPoint);
        int arrayWidth = this.din.readInt();
        this.header.setArrayWidth(arrayWidth);
        int arrayHeight = this.din.readInt();
        this.header.setArrayHeight(arrayHeight);
        int dataBlockLength = this.din.readInt();
        this.header.setDataBlockLength(dataBlockLength);
        int scaleFlag = this.din.readInt();
        this.header.setScaleFlag(scaleFlag);
        float iScale = this.din.readFloat();
        this.header.setIScale(iScale);
        float jScale = this.din.readFloat();
        this.header.setJScale(jScale);
        int transfoMatrixFlag = this.din.readInt();
        this.header.setTransfoMatrixFlag(transfoMatrixFlag);
        double[] transMatrixData = new double[16];
        int i = 0;
        while (i < transMatrixData.length) {
            transMatrixData[i] = this.din.readDouble();
            ++i;
        }
        Matrix4d transMatrix = new Matrix4d(transMatrixData);
        this.header.setTransfoMatrix(transMatrix);
        int imageColorFlag = this.din.readInt();
        this.header.setImageColorFlag(imageColorFlag);
        int colorBlockLength = this.din.readInt();
        this.header.setColorBlockLength(colorBlockLength);
        int cameraPositionFlag = this.din.readInt();
        this.header.setCameraPositionFlag(cameraPositionFlag);
        float cameraX = this.din.readFloat();
        this.header.setCameraX(cameraX);
        float cameraY = this.din.readFloat();
        this.header.setCameraY(cameraY);
        float cameraZ = this.din.readFloat();
        this.header.setCameraZ(cameraZ);
        int[] dummy2 = new int[30];
        int i2 = 0;
        while (i2 < 30) {
            dummy2[i2] = this.din.readInt();
            ++i2;
        }
        this.header.setDummy2(dummy2);
    }

    private void readPoints() throws IOException {
        this.points = new ArrayList<Point3f>(this.header.getArrayHeight() * this.header.getArrayWidth());
        if (this.header.getImageDataType() == 1) {
            float[] pointData = new float[3];
            int i = 0;
            while (i < this.header.getArrayHeight()) {
                int j = 0;
                while (j < this.header.getArrayWidth()) {
                    int k = 0;
                    while (k < 3) {
                        pointData[k] = this.din.readFloat();
                        ++k;
                    }
                    this.points.add(new Point3f(pointData));
                    ++j;
                }
                ++i;
            }
        } else {
            System.err.println("Only data type 1 is supported at this moment.");
        }
    }

    public PifHeader getHeader() {
        return this.header;
    }

    public List<Point3f> getPoints() {
        return this.points;
    }

    public List<Color4b> getColors() {
        return this.colors;
    }
}

