/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.ui.jme3;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.vecmath.Tuple3d;
import org.eclipse.apogy.common.geometry.data.Coordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianAxis;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.ColoredCartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.emf.common.util.EList;

public class Data3dJME3Utilities {
    public static boolean verbose = false;

    public static Mesh createMesh(CartesianTriangularMesh cartesianTriangularMesh) {
        return Data3dJME3Utilities.createMesh(cartesianTriangularMesh, true, null);
    }

    public static Mesh createMesh(CartesianTriangularMesh cartesianTriangularMesh, boolean overrideColor, ColorRGBA defaultVertexColor) {
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Triangles);
        if (cartesianTriangularMesh != null && cartesianTriangularMesh.getPoints() != null && cartesianTriangularMesh.getPolygons() != null && cartesianTriangularMesh.getPoints().size() > 0 && cartesianTriangularMesh.getPolygons().size() > 0) {
            if (verbose) {
                System.err.println("Mesh Points    : " + cartesianTriangularMesh.getPoints().size());
                System.err.println("Mesh Triangles : " + cartesianTriangularMesh.getPolygons().size());
            }
            WeakHashMap<CartesianPositionCoordinates, Integer> pointToIndexMap = new WeakHashMap<CartesianPositionCoordinates, Integer>();
            Vector3f[] verticesArray = new Vector3f[cartesianTriangularMesh.getPoints().size()];
            ArrayList<Integer> indexesList = new ArrayList<Integer>();
            ArrayList<Vector3f> normalslList = new ArrayList<Vector3f>();
            ArrayList<ColorRGBA> pointColorList = new ArrayList<ColorRGBA>();
            Vector2f[] textureCoordArray = new Vector2f[cartesianTriangularMesh.getPoints().size()];
            float minX = (float)Geometry3DUtilities.getMinimumPosition((CartesianAxis)CartesianAxis.X, (List)cartesianTriangularMesh.getPoints()).getX();
            float maxX = (float)Geometry3DUtilities.getMaximumPosition((CartesianAxis)CartesianAxis.X, (List)cartesianTriangularMesh.getPoints()).getX();
            float xExtent = maxX - minX;
            float minY = (float)Geometry3DUtilities.getMinimumPosition((CartesianAxis)CartesianAxis.Y, (List)cartesianTriangularMesh.getPoints()).getY();
            float maxY = (float)Geometry3DUtilities.getMaximumPosition((CartesianAxis)CartesianAxis.Y, (List)cartesianTriangularMesh.getPoints()).getY();
            float yExtent = maxY - minY;
            int index = 0;
            for (CartesianPositionCoordinates point : cartesianTriangularMesh.getPoints()) {
                Vector2f textCoord;
                float textureY;
                verticesArray[index] = new Vector3f((float)point.getX(), (float)point.getY(), (float)point.getZ());
                pointToIndexMap.put(point, new Integer(index));
                float textureX = ((float)point.getX() - minX) / xExtent;
                if (textureX < 0.0f) {
                    textureX = 0.0f;
                }
                if (textureX > 1.0f) {
                    textureX = 1.0f;
                }
                if ((textureY = ((float)point.getY() - minY) / yExtent) < 0.0f) {
                    textureY = 0.0f;
                }
                if (textureY > 1.0f) {
                    textureY = 1.0f;
                }
                textureCoordArray[index] = textCoord = new Vector2f(textureX, textureY);
                ColorRGBA pointColor = null;
                if (overrideColor) {
                    pointColor = defaultVertexColor != null ? new ColorRGBA(defaultVertexColor) : new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
                } else if (point instanceof ColoredCartesianPositionCoordinates) {
                    float b;
                    float g;
                    ColoredCartesianPositionCoordinates coloredPoint = (ColoredCartesianPositionCoordinates)point;
                    float r = (float)coloredPoint.getRed() / 255.0f;
                    if (r < 0.0f) {
                        r = 0.0f;
                    }
                    if (r > 1.0f) {
                        r = 1.0f;
                    }
                    if ((g = (float)coloredPoint.getGreen() / 255.0f) < 0.0f) {
                        g = 0.0f;
                    }
                    if (g > 1.0f) {
                        g = 1.0f;
                    }
                    if ((b = (float)coloredPoint.getBlue() / 255.0f) < 0.0f) {
                        b = 0.0f;
                    }
                    if (b > 1.0f) {
                        b = 1.0f;
                    }
                    pointColor = new ColorRGBA(r, g, b, 1.0f);
                } else {
                    pointColor = defaultVertexColor != null ? new ColorRGBA(defaultVertexColor) : new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
                }
                pointColorList.add(pointColor);
                ++index;
            }
            for (CartesianTriangle triangle : cartesianTriangularMesh.getPolygons()) {
                for (CartesianPositionCoordinates vertice : triangle.getVertices()) {
                    Integer verticeIndex = (Integer)pointToIndexMap.get(vertice);
                    indexesList.add(verticeIndex);
                }
            }
            for (CartesianPositionCoordinates point : cartesianTriangularMesh.getPoints()) {
                EList triangles = cartesianTriangularMesh.getPolygonsSharingPoint((Coordinates)point);
                Vector3f normal = Data3dJME3Utilities.computeAverageNormal((EList<CartesianTriangle>)triangles);
                normalslList.add(normal);
            }
            if (verbose) {
                System.err.println("Position : " + verticesArray.length);
                System.err.println("Index    : " + indexesList.size());
                System.err.println("Normal   : " + normalslList.size());
                System.err.println("Color    : " + pointColorList.size());
            }
            mesh.setMode(Mesh.Mode.Triangles);
            mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((Vector3f[])verticesArray));
            mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
            mesh.setBuffer(VertexBuffer.Type.Normal, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(normalslList)));
            mesh.setBuffer(VertexBuffer.Type.TexCoord, 2, BufferUtils.createFloatBuffer((Vector2f[])textureCoordArray));
            mesh.setBuffer(VertexBuffer.Type.Color, 4, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertRGBAListToFloatArray(pointColorList)));
            mesh.updateBound();
            mesh.updateCounts();
        }
        return mesh;
    }

    public static Vector3f computeAverageNormal(EList<CartesianTriangle> triangles) {
        Vector3f normal = new Vector3f(0.0f, 0.0f, 0.0f);
        for (CartesianTriangle triangle : triangles) {
            Vector3f triangleNormal = JME3Utilities.convertToVector3f((Tuple3d)triangle.getNormal());
            triangleNormal = triangleNormal.normalize();
            triangleNormal.mult((float)triangle.getSurface());
            normal = normal.add(triangleNormal);
        }
        normal.normalize();
        return normal;
    }
}

