/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.ColoredCartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.ColoredCartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.ui.jme3.Activator;
import org.eclipse.apogy.common.geometry.data3d.ui.scene_objects.ColoredCartesianCoordinatesSetSceneObject;
import org.eclipse.apogy.common.topology.ContentNode;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColoredCartesianCoordinateSetJME3SceneObject<T extends ColoredCartesianCoordinatesSet>
extends DefaultJME3SceneObject<ContentNode<T>>
implements ColoredCartesianCoordinatesSetSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(ColoredCartesianCoordinateSetJME3SceneObject.class);
    private boolean overrideColor = false;
    private ColorRGBA pointsColor = ColoredCartesianCoordinateSetJME3SceneObject.getDefaultPointColor();
    private RGB rgb = ColoredCartesianCoordinateSetJME3SceneObject.getDefaultRGBPointColor();
    private int pointSize = 1;
    private ColoredCartesianCoordinatesSet points;
    private Point3d centroid = null;
    private AssetManager assetManager;
    private Geometry meshGeometry = null;
    private Mesh jme3mMesh = null;
    private Adapter modelListener;

    public ColoredCartesianCoordinateSetJME3SceneObject(ContentNode<T> node, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super(node, jme3RenderEngineDelegate);
        if (node == null || jme3RenderEngineDelegate == null) {
            throw new IllegalArgumentException();
        }
        this.assetManager = this.jme3Application.getAssetManager();
        this.points = (ColoredCartesianCoordinatesSet)node.getContent();
        Job job = new Job("CartesianCoordinatesSetJME3Object : Creating geometry"){

            protected IStatus run(IProgressMonitor monitor) {
                ColoredCartesianCoordinateSetJME3SceneObject.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        ColoredCartesianCoordinateSetJME3SceneObject.this.requestUpdate();
                        ColoredCartesianCoordinateSetJME3SceneObject.this.points.eAdapters().add((Object)ColoredCartesianCoordinateSetJME3SceneObject.this.getPointsListener());
                        return null;
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void updateGeometry(float tpf) {
        this.updateGeometryInternal(this.points);
    }

    public Point3d getCentroid() {
        if (this.centroid == null) {
            this.centroid = new Point3d(0.0, 0.0, 0.0);
            if (this.points.getPoints().size() > 0) {
                for (CartesianPositionCoordinates point : this.points.getPoints()) {
                    this.centroid.x += point.getX();
                    this.centroid.y += point.getY();
                    this.centroid.z += point.getZ();
                }
                this.centroid.scale(1.0 / (double)this.points.getPoints().size());
            }
        }
        return this.centroid;
    }

    public void setPointSize(final int pointSize) {
        Logger.info("Setting point size to <" + pointSize + ">.");
        this.pointSize = pointSize;
        if (this.jme3mMesh != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    if (ColoredCartesianCoordinateSetJME3SceneObject.this.jme3mMesh != null) {
                        ColoredCartesianCoordinateSetJME3SceneObject.this.jme3mMesh.setPointSize((float)pointSize);
                    }
                    return null;
                }
            });
        }
    }

    public int getPointSize() {
        return this.pointSize;
    }

    public void setColor(RGB rgb) {
        Logger.info("Setting color to <" + rgb + ">.");
        this.rgb = rgb;
        this.pointsColor = JME3Utilities.convertToColorRGBA((RGB)rgb);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (ColoredCartesianCoordinateSetJME3SceneObject.this.points != null) {
                    ColoredCartesianCoordinateSetJME3SceneObject.this.updateGeometryInternal(ColoredCartesianCoordinateSetJME3SceneObject.this.points);
                }
                return null;
            }
        });
    }

    public RGB getColor() {
        return this.rgb;
    }

    public void setOverrideColor(boolean overrideColor) {
        Logger.info("Setting Override Color flag to " + overrideColor);
        this.overrideColor = overrideColor;
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (ColoredCartesianCoordinateSetJME3SceneObject.this.points != null) {
                    ColoredCartesianCoordinateSetJME3SceneObject.this.updateGeometryInternal(ColoredCartesianCoordinateSetJME3SceneObject.this.points);
                }
                return null;
            }
        });
    }

    public void dispose() {
        if (this.points != null) {
            this.points.eAdapters().remove((Object)this.getPointsListener());
        }
        super.dispose();
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.meshGeometry);
        return geometries;
    }

    private void updateGeometryInternal(ColoredCartesianCoordinatesSet points) {
        try {
            this.busy = true;
            ArrayList pointsInternal = new ArrayList();
            pointsInternal.addAll(points.getPoints());
            if (this.meshGeometry != null) {
                this.getAttachmentNode().detachChild((Spatial)this.meshGeometry);
            }
            ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
            ArrayList<Integer> indexesList = new ArrayList<Integer>();
            ArrayList<ColorRGBA> pointColorList = new ArrayList<ColorRGBA>();
            int index = 0;
            for (CartesianPositionCoordinates point : pointsInternal) {
                verticesList.add(new Vector3f((float)point.getX(), (float)point.getY(), (float)point.getZ()));
                indexesList.add(new Integer(index));
                ColorRGBA pointColor = null;
                if (this.overrideColor) {
                    pointColor = new ColorRGBA(this.pointsColor);
                } else if (point instanceof ColoredCartesianPositionCoordinates) {
                    ColoredCartesianPositionCoordinates coloredPoint = (ColoredCartesianPositionCoordinates)point;
                    float r = (float)coloredPoint.getRed() / 255.0f;
                    float g = (float)coloredPoint.getGreen() / 255.0f;
                    float b = (float)coloredPoint.getBlue() / 255.0f;
                    pointColor = new ColorRGBA(r, g, b, 1.0f);
                } else {
                    pointColor = new ColorRGBA(this.pointsColor);
                }
                pointColorList.add(pointColor);
                ++index;
            }
            this.jme3mMesh = new Mesh();
            this.jme3mMesh.setMode(Mesh.Mode.Points);
            this.jme3mMesh.setPointSize((float)this.getPointSize());
            this.jme3mMesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
            this.jme3mMesh.setBuffer(VertexBuffer.Type.Index, 1, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
            this.jme3mMesh.setBuffer(VertexBuffer.Type.Color, 4, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertRGBAListToFloatArray(pointColorList)));
            this.jme3mMesh.updateBound();
            this.jme3mMesh.updateCounts();
            this.meshGeometry = ((ContentNode)this.getTopologyNode()).getNodeId() != null ? new Geometry(((ContentNode)this.getTopologyNode()).getNodeId(), this.jme3mMesh) : new Geometry("CartesianCoordinatesSet", this.jme3mMesh);
            this.meshGeometry.setMaterial(this.createMaterial());
            this.getAttachmentNode().attachChild((Spatial)this.meshGeometry);
            this.busy = false;
        }
        catch (Throwable t) {
            this.busy = false;
        }
    }

    private static RGB getDefaultRGBPointColor() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"DEFAULT_CARTESIAN_COORD_SET_COLOR_ID");
        return rgb;
    }

    private static ColorRGBA getDefaultPointColor() {
        RGB rgb = ColoredCartesianCoordinateSetJME3SceneObject.getDefaultRGBPointColor();
        if (rgb != null) {
            return JME3Utilities.convertToColorRGBA((RGB)rgb).clone();
        }
        return ColorRGBA.White.clone();
    }

    private Material createMaterial() {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.getAdditionalRenderState().setFaceCullMode(RenderState.FaceCullMode.Off);
        mat.setBoolean("VertexColor", true);
        return mat;
    }

    private Adapter getPointsListener() {
        if (this.modelListener == null) {
            this.modelListener = new AdapterImpl(){

                /*
                 * Enabled aggressive block sorting
                 */
                public void notifyChanged(Notification notification) {
                    int featureId = notification.getFeatureID(ColoredCartesianCoordinatesSet.class);
                    switch (featureId) {
                        case 0: {
                            int eventType = notification.getEventType();
                            switch (eventType) {
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: {
                                    if (ColoredCartesianCoordinateSetJME3SceneObject.this.busy) return;
                                    ColoredCartesianCoordinateSetJME3SceneObject.this.busy = true;
                                    Job job = new Job("CartesianCoordinatesSetJME3Object : Updating geometry"){

                                        protected IStatus run(IProgressMonitor monitor) {
                                            ColoredCartesianCoordinateSetJME3SceneObject.this.requestUpdate();
                                            return Status.OK_STATUS;
                                        }
                                    };
                                    job.schedule();
                                    return;
                                }
                            }
                            return;
                        }
                    }
                }
            };
        }
        return this.modelListener;
    }
}

