/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.converters;

import java.io.File;
import java.io.FileInputStream;
import org.eclipse.apogy.common.converters.IConverter;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.Data3DIO;

public class TopoFileToCartesianTriangularMeshConverter
implements IConverter {
    public Class<?> getOutputType() {
        return CartesianTriangularMesh.class;
    }

    public Class<?> getInputType() {
        return File.class;
    }

    public boolean canConvert(Object input) {
        if (input instanceof File) {
            File file = (File)input;
            return this.getFileExtension(file.getName()).endsWith(".topo") || this.getFileExtension(file.getName()).endsWith(".xml");
        }
        return false;
    }

    public Object convert(Object input) throws Exception {
        File file = (File)input;
        FileInputStream inputStream = new FileInputStream(file);
        return Data3DIO.INSTANCE.loadTriangularMesh(inputStream);
    }

    protected String getFileExtension(String url) {
        String fileExtension = new String();
        String fileName = url;
        int index = fileName.lastIndexOf(".");
        if (index >= 0) {
            fileExtension = fileName.substring(index);
            fileExtension = fileExtension.toLowerCase();
        }
        return fileExtension;
    }
}

