/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.NormalPointCloud;
import org.eclipse.apogy.common.geometry.data3d.impl.Data3DIOImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Data3DIOCustomImpl
extends Data3DIOImpl {
    private static final Logger Logger = LoggerFactory.getLogger(Data3DIOImpl.class);

    @Override
    public void saveTriangularMesh(CartesianTriangularMesh mesh, String file) throws IOException {
        this.saveTriangularMesh(mesh, new FileOutputStream(file));
    }

    @Override
    public CartesianTriangularMesh loadTriangularMesh(String file) throws IOException {
        return this.loadTriangularMesh(new FileInputStream(file));
    }

    @Override
    public void saveTriangularMesh(CartesianTriangularMesh mesh, OutputStream output) throws IOException {
        XMIResourceImpl resource = new XMIResourceImpl();
        resource.getContents().add((Object)mesh);
        resource.save(output, Collections.EMPTY_MAP);
    }

    @Override
    public CartesianTriangularMesh loadTriangularMesh(InputStream input) throws IOException {
        XMIResourceImpl resource = new XMIResourceImpl();
        resource.load(input, Collections.EMPTY_MAP);
        if (!(resource.getContents().get(0) instanceof CartesianTriangularMesh)) {
            throw new IOException("Object loaded, but content is invalid");
        }
        return (CartesianTriangularMesh)resource.getContents().get(0);
    }

    @Override
    public NormalPointCloud loadTriangularMeshFromASCIIAsNormalPointCloud(String filePrefix) throws IOException {
        NormalPointCloud normalPointCloud = ApogyCommonGeometryData3DFactory.eINSTANCE.createNormalPointCloud();
        ArrayList<Point3d> points = new ArrayList<Point3d>();
        ArrayList<Vector3d> normals = new ArrayList<Vector3d>();
        this.loadTriangularMeshFromASCII(filePrefix, points, normals, null, true);
        normalPointCloud.setPoints(points);
        normalPointCloud.setNormals(normals);
        return normalPointCloud;
    }

    @Override
    public CartesianTriangularMesh loadTriangularMeshFromASCII(String filePrefix) throws IOException {
        CartesianTriangularMesh mesh = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangularMesh();
        ArrayList<Point3d> points = new ArrayList<Point3d>();
        ArrayList<IndexedTriangle> triangles = new ArrayList<IndexedTriangle>();
        ArrayList<Vector3d> normals = new ArrayList<Vector3d>();
        this.loadTriangularMeshFromASCII(filePrefix, points, normals, triangles, true);
        ArrayList<CartesianPositionCoordinates> coordinates = new ArrayList<CartesianPositionCoordinates>();
        ArrayList<CartesianTriangle> cartTriangles = new ArrayList<CartesianTriangle>();
        for (Point3d point : points) {
            CartesianPositionCoordinates coord = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(point.x, point.y, point.z);
            coordinates.add(coord);
        }
        mesh.getPoints().addAll(coordinates);
        for (IndexedTriangle tri : triangles) {
            CartesianPositionCoordinates v0 = (CartesianPositionCoordinates)mesh.getPoints().get(tri.getV0());
            CartesianPositionCoordinates v1 = (CartesianPositionCoordinates)mesh.getPoints().get(tri.getV1());
            CartesianPositionCoordinates v2 = (CartesianPositionCoordinates)mesh.getPoints().get(tri.getV2());
            CartesianTriangle triangle = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangle(v0, v1, v2);
            cartTriangles.add(triangle);
        }
        mesh.getPolygons().addAll(cartTriangles);
        if (normals.size() > 0) {
            mesh.setNormals(normals);
        }
        return mesh;
    }

    @Override
    public void saveTriangularMeshAsASCII(CartesianTriangularMesh mesh, String filePrefix) throws IOException {
        File pointsFile = new File(String.valueOf(filePrefix) + ".xyz");
        StringBuffer pointDataBuffer = new StringBuffer();
        Vector3d normal = null;
        int i = 0;
        while (i < mesh.getPoints().size()) {
            CartesianPositionCoordinates point = (CartesianPositionCoordinates)mesh.getPoints().get(i);
            normal = mesh.getNormals() != null && mesh.getNormals().size() == mesh.getPoints().size() ? (Vector3d)mesh.getNormals().get(i) : null;
            pointDataBuffer.append(String.valueOf(point.getX()) + " " + point.getY() + " " + point.getZ());
            if (normal != null) {
                pointDataBuffer.append(" " + normal.getX() + " " + normal.getY() + " " + normal.getZ());
            }
            pointDataBuffer.append("\n");
            ++i;
        }
        FileWriter pointsFileWriter = new FileWriter(pointsFile);
        pointsFileWriter.write(pointDataBuffer.toString());
        pointsFileWriter.flush();
        pointsFileWriter.close();
        File trianglesFile = new File(String.valueOf(filePrefix) + ".tri");
        StringBuffer triangleDataBuffer = new StringBuffer();
        int numberOfPoints = mesh.getPoints().size();
        HashMap<CartesianPositionCoordinates, Integer> pointToIndexMap = new HashMap<CartesianPositionCoordinates, Integer>(numberOfPoints);
        int index = 0;
        while (index < numberOfPoints) {
            CartesianPositionCoordinates point = (CartesianPositionCoordinates)mesh.getPoints().get(index);
            pointToIndexMap.put(point, index + 1);
            ++index;
        }
        int numberOfTriangles = mesh.getPolygons().size();
        int i2 = 0;
        while (i2 < numberOfTriangles) {
            CartesianTriangle triangle = (CartesianTriangle)mesh.getPolygons().get(i2);
            int v1 = (Integer)pointToIndexMap.get(triangle.getVertices().get(0));
            int v2 = (Integer)pointToIndexMap.get(triangle.getVertices().get(1));
            int v3 = (Integer)pointToIndexMap.get(triangle.getVertices().get(2));
            triangleDataBuffer.append(String.valueOf(v1) + " " + v2 + " " + v3 + "\n");
            ++i2;
        }
        FileWriter triangleFileWriter = new FileWriter(trianglesFile);
        triangleFileWriter.write(triangleDataBuffer.toString());
        triangleFileWriter.flush();
        triangleFileWriter.close();
    }

    @Override
    public CartesianCoordinatesSet loadXYZ(String fileName) throws IOException {
        CartesianCoordinatesSet points = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSet();
        FileInputStream fis = new FileInputStream(new File(fileName));
        InputStreamReader streamReader = new InputStreamReader(fis);
        BufferedReader fileReader = new BufferedReader(streamReader);
        boolean eof = false;
        int lineNumber = 1;
        try {
            while (!eof) {
                String line = fileReader.readLine();
                boolean bl = eof = line == null;
                if (!eof) {
                    String[] cols = line.split("\\s+");
                    if (cols.length != 3) {
                        throw new IllegalArgumentException("File " + fileName + "(" + lineNumber + "): expected 3 columns, found " + cols.length);
                    }
                    try {
                        double x = Double.parseDouble(cols[0]);
                        double y = Double.parseDouble(cols[1]);
                        double z = Double.parseDouble(cols[2]);
                        CartesianPositionCoordinates point = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, y, z);
                        points.getPoints().add((Object)point);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("File " + fileName + "(" + lineNumber + "): error while parsing numerical values: " + e.getMessage());
                    }
                }
                ++lineNumber;
            }
        }
        finally {
            fileReader.close();
        }
        return points;
    }

    @Override
    public CartesianCoordinatesSet loadXYZ(InputStream input) throws IOException {
        CartesianCoordinatesSet points = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSet();
        InputStreamReader streamReader = new InputStreamReader(input);
        BufferedReader fileReader = new BufferedReader(streamReader);
        boolean eof = false;
        int lineNumber = 1;
        try {
            while (!eof) {
                String line = fileReader.readLine();
                boolean bl = eof = line == null;
                if (!eof) {
                    String[] cols = line.split("\\s+");
                    if (cols.length != 3) {
                        throw new IllegalArgumentException("File (" + lineNumber + "): expected 3 columns, found " + cols.length);
                    }
                    try {
                        double x = Double.parseDouble(cols[0]);
                        double y = Double.parseDouble(cols[1]);
                        double z = Double.parseDouble(cols[2]);
                        CartesianPositionCoordinates point = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(x, y, z);
                        points.getPoints().add((Object)point);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("File (" + lineNumber + "): error while parsing numerical values: " + e.getMessage());
                    }
                }
                ++lineNumber;
            }
        }
        finally {
            fileReader.close();
        }
        return points;
    }

    @Override
    public CartesianTriangularMesh loadTriangularMeshFromTriXYZ(String triFileName, String xyzFileName) throws IOException {
        CartesianTriangularMesh mesh = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianTriangularMesh();
        ArrayList<Point3d> points = new ArrayList<Point3d>();
        ArrayList<IndexedTriangle> triangles = new ArrayList<IndexedTriangle>();
        ArrayList<Vector3d> normals = new ArrayList<Vector3d>();
        this.loadTriangularMeshFromASCII(triFileName, xyzFileName, points, normals, triangles, true);
        ArrayList<CartesianPositionCoordinates> coordinates = new ArrayList<CartesianPositionCoordinates>();
        ArrayList<CartesianTriangle> cartTriangles = new ArrayList<CartesianTriangle>();
        for (Point3d point : points) {
            CartesianPositionCoordinates coord = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(point.x, point.y, point.z);
            coordinates.add(coord);
        }
        mesh.getPoints().addAll(coordinates);
        for (IndexedTriangle tri : triangles) {
            CartesianPositionCoordinates v0 = (CartesianPositionCoordinates)mesh.getPoints().get(tri.getV0());
            CartesianPositionCoordinates v1 = (CartesianPositionCoordinates)mesh.getPoints().get(tri.getV1());
            CartesianPositionCoordinates v2 = (CartesianPositionCoordinates)mesh.getPoints().get(tri.getV2());
            CartesianTriangle triangle = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianTriangle(v0, v1, v2);
            cartTriangles.add(triangle);
        }
        mesh.getPolygons().addAll(cartTriangles);
        if (normals.size() > 0) {
            mesh.setNormals(normals);
        }
        return mesh;
    }

    @Override
    public void saveCoordinatesSetToCSV(CartesianCoordinatesSet coordinatesSet, OutputStream file) throws IOException {
        PrintStream printStream = new PrintStream(file);
        StringBuffer pointDataBuffer = new StringBuffer();
        Vector3d normal = null;
        int i = 0;
        while (i < coordinatesSet.getPoints().size()) {
            CartesianPositionCoordinates point = (CartesianPositionCoordinates)coordinatesSet.getPoints().get(i);
            normal = coordinatesSet.getNormals() != null && coordinatesSet.getNormals().size() == coordinatesSet.getPoints().size() ? (Vector3d)coordinatesSet.getNormals().get(i) : null;
            pointDataBuffer.append(String.valueOf(point.getX()) + "," + point.getY() + "," + point.getZ());
            if (normal != null) {
                pointDataBuffer.append("," + normal.getX() + "," + normal.getY() + "," + normal.getZ());
            }
            pointDataBuffer.append("\n");
            ++i;
        }
        printStream.print(pointDataBuffer.toString());
        printStream.flush();
        printStream.close();
    }

    @Override
    public void saveCoordinatesSetToCSV(CartesianCoordinatesSet coordinatesSet, String file) throws IOException {
        this.saveCoordinatesSetToCSV(coordinatesSet, new FileOutputStream(file));
    }

    @Override
    public void saveCoordinatesSetToXYZ(CartesianCoordinatesSet coordinatesSet, String file) throws IOException {
        this.saveCoordinatesSetToXYZ(coordinatesSet, new FileOutputStream(file));
    }

    @Override
    public void saveCoordinatesSetToXYZ(CartesianCoordinatesSet coordinatesSet, OutputStream file) throws IOException {
        PrintStream printStream = new PrintStream(file);
        StringBuffer pointDataBuffer = new StringBuffer();
        Vector3d normal = null;
        int i = 0;
        while (i < coordinatesSet.getPoints().size()) {
            CartesianPositionCoordinates point = (CartesianPositionCoordinates)coordinatesSet.getPoints().get(i);
            normal = coordinatesSet.getNormals() != null && coordinatesSet.getNormals().size() == coordinatesSet.getPoints().size() ? (Vector3d)coordinatesSet.getNormals().get(i) : null;
            pointDataBuffer.append(String.valueOf(point.getX()) + " " + point.getY() + " " + point.getZ());
            if (normal != null) {
                pointDataBuffer.append(" " + normal.getX() + " " + normal.getY() + " " + normal.getZ());
            }
            pointDataBuffer.append("\n");
            ++i;
        }
        printStream.print(pointDataBuffer.toString());
        printStream.flush();
        printStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        try {
            switch (operationID) {
                case 2: {
                    this.saveTriangularMesh((CartesianTriangularMesh)arguments.get(0), (String)arguments.get(1));
                    return null;
                }
                case 0: {
                    return this.loadTriangularMesh((String)arguments.get(0));
                }
                case 3: {
                    this.saveTriangularMesh((CartesianTriangularMesh)arguments.get(0), (OutputStream)arguments.get(1));
                    return null;
                }
                case 1: {
                    return this.loadTriangularMesh((InputStream)arguments.get(0));
                }
                case 4: {
                    return this.loadTriangularMeshFromASCIIAsNormalPointCloud((String)arguments.get(0));
                }
                case 5: {
                    return this.loadTriangularMeshFromASCII((String)arguments.get(0));
                }
                case 6: {
                    this.saveTriangularMeshAsASCII((CartesianTriangularMesh)arguments.get(0), (String)arguments.get(1));
                    return null;
                }
                case 7: {
                    return this.loadXYZ((String)arguments.get(0));
                }
            }
            return super.eInvoke(operationID, arguments);
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        return super.eInvoke(operationID, arguments);
    }

    private void loadTriangularMeshFromASCII(String triFileName, String xyzFileName, List<Point3d> points, List<Vector3d> normals, List<IndexedTriangle> triangles, boolean loadNormals) throws IOException {
        File pointsFile = new File(xyzFileName);
        File trianglesFile = new File(triFileName);
        FileInputStream pointsIS = new FileInputStream(pointsFile);
        BufferedReader pointsReader = new BufferedReader(new InputStreamReader(pointsIS));
        boolean loadTriangles = trianglesFile.exists();
        int lineNumber = 1;
        double[] xyz = new double[3];
        double[] normal = new double[3];
        boolean eof = false;
        try {
            while (!eof) {
                String line = pointsReader.readLine();
                boolean bl = eof = line == null;
                if (eof) continue;
                String[] coords = line.split("\\s+");
                if (coords.length != 3 && coords.length != 6) {
                    throw new IllegalArgumentException("Illegal file format at " + pointsFile.getName() + "(" + lineNumber + ")");
                }
                int i = 0;
                while (i < 3) {
                    try {
                        xyz[i] = Double.parseDouble(coords[i]);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Illegal file format at " + pointsFile.getName() + "(" + lineNumber + ")");
                    }
                    ++i;
                }
                if (loadNormals && coords.length == 6) {
                    i = 0;
                    while (i < 3) {
                        try {
                            normal[i] = Double.parseDouble(coords[i + 3]);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Illegal file format at " + pointsFile.getName() + "(" + lineNumber + ")");
                        }
                        ++i;
                    }
                }
                if (points != null) {
                    points.add(new Point3d(xyz));
                }
                if (normals != null && coords.length == 6) {
                    Vector3d n = new Vector3d(normal);
                    n.normalize();
                    normals.add(n);
                }
                ++lineNumber;
            }
        }
        finally {
            pointsReader.close();
        }
        if (triangles != null && loadTriangles) {
            lineNumber = 1;
            int[] triangle = new int[3];
            eof = false;
            FileInputStream trianglesIS = new FileInputStream(trianglesFile);
            try (BufferedReader trianglesReader = new BufferedReader(new InputStreamReader(trianglesIS));){
                while (!eof) {
                    String line = trianglesReader.readLine();
                    boolean bl = eof = line == null;
                    if (eof) continue;
                    String[] coords = line.split("\\s+");
                    if (coords.length != 3) {
                        throw new IllegalArgumentException("Illegal file format at " + trianglesFile.getName() + "(" + lineNumber + ")");
                    }
                    int i = 0;
                    while (i < coords.length) {
                        try {
                            triangle[i] = Integer.parseInt(coords[i]);
                            int n = i;
                            triangle[n] = triangle[n] - 1;
                            if (triangle[i] < 0 || triangle[i] >= points.size()) {
                                throw new IllegalArgumentException("Index " + i + " is invalid at " + pointsFile.getName() + "(" + lineNumber + "): " + triangle[i] + "/" + points.size());
                            }
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Illegal file format at " + pointsFile.getName() + "(" + lineNumber + "): coordinate [" + coords[i] + "] is not an integer.");
                        }
                        ++i;
                    }
                    IndexedTriangle indexedTriangle = new IndexedTriangle(triangle[0], triangle[1], triangle[2]);
                    triangles.add(indexedTriangle);
                }
            }
        }
    }

    private void loadTriangularMeshFromASCII(String filePrefix, List<Point3d> points, List<Vector3d> normals, List<IndexedTriangle> triangles, boolean loadNormals) throws IOException {
        File pointsFile = new File(String.valueOf(filePrefix) + ".xyz");
        File trianglesFile = new File(String.valueOf(filePrefix) + ".tri");
        FileInputStream pointsIS = new FileInputStream(pointsFile);
        BufferedReader pointsReader = new BufferedReader(new InputStreamReader(pointsIS));
        boolean loadTriangles = trianglesFile.exists();
        int lineNumber = 1;
        double[] xyz = new double[3];
        double[] normal = new double[3];
        boolean eof = false;
        try {
            while (!eof) {
                String line = pointsReader.readLine();
                boolean bl = eof = line == null;
                if (eof) continue;
                String[] coords = line.split("\\s+");
                if (coords.length != 3 && coords.length != 6) {
                    throw new IllegalArgumentException("Illegal file format at " + pointsFile.getName() + "(" + lineNumber + ")");
                }
                int i = 0;
                while (i < 3) {
                    try {
                        xyz[i] = Double.parseDouble(coords[i]);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Illegal file format at " + pointsFile.getName() + "(" + lineNumber + ")");
                    }
                    ++i;
                }
                if (loadNormals && coords.length == 6) {
                    i = 0;
                    while (i < 3) {
                        try {
                            normal[i] = Double.parseDouble(coords[i + 3]);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Illegal file format at " + pointsFile.getName() + "(" + lineNumber + ")");
                        }
                        ++i;
                    }
                }
                if (points != null) {
                    points.add(new Point3d(xyz));
                }
                if (normals != null && coords.length == 6) {
                    Vector3d n = new Vector3d(normal);
                    n.normalize();
                    normals.add(n);
                }
                ++lineNumber;
            }
        }
        finally {
            pointsReader.close();
        }
        if (triangles != null && loadTriangles) {
            lineNumber = 1;
            int[] triangle = new int[3];
            eof = false;
            FileInputStream trianglesIS = new FileInputStream(trianglesFile);
            try (BufferedReader trianglesReader = new BufferedReader(new InputStreamReader(trianglesIS));){
                while (!eof) {
                    String line = trianglesReader.readLine();
                    boolean bl = eof = line == null;
                    if (eof) continue;
                    String[] coords = line.split("\\s+");
                    if (coords.length != 3) {
                        throw new IllegalArgumentException("Illegal file format at " + trianglesFile.getName() + "(" + lineNumber + ")");
                    }
                    int i = 0;
                    while (i < coords.length) {
                        try {
                            triangle[i] = Integer.parseInt(coords[i]);
                            int n = i;
                            triangle[n] = triangle[n] - 1;
                            if (triangle[i] < 0 || triangle[i] >= points.size()) {
                                throw new IllegalArgumentException("Index " + i + " is invalid at " + pointsFile.getName() + "(" + lineNumber + "): " + triangle[i] + "/" + points.size());
                            }
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("Illegal file format at " + pointsFile.getName() + "(" + lineNumber + "): coordinate [" + coords[i] + "] is not an integer.");
                        }
                        ++i;
                    }
                    IndexedTriangle indexedTriangle = new IndexedTriangle(triangle[0], triangle[1], triangle[2]);
                    triangles.add(indexedTriangle);
                }
            }
        }
    }

    private class IndexedTriangle {
        private final int v0;
        private final int v1;
        private final int v2;

        public IndexedTriangle(int v0, int v1, int v2) {
            this.v0 = v0;
            this.v1 = v1;
            this.v2 = v2;
        }

        public int getV0() {
            return this.v0;
        }

        public int getV1() {
            return this.v1;
        }

        public int getV2() {
            return this.v2;
        }
    }
}

